C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine readdigi(iyear,imon,iday)
      character*3   cha3
      character*4   cha4,cha4a
      character*23  root
      character*43  filename
      character*80  cha80
      character*120 chapref
      logical      lexist
      dimension    alt(288,999),freq(288,999),npts(288),xhr(288),
     &  xmn(288),xsec(288)
      common   /c22data/ alt,freq,npts,nprof,xhr,xmn,xsec
      dimension    rmxalt(288)
      common /cmmaxalt/ rmxalt
      common /cmmiok/    iok
      common /cmmsite/  isite
      common /cmcha80/  cha80
      LOGICAL   EOF
      CHARACTER*17 TIME
      INTEGER*2 IDFI(80),IAF(60),IOTF(400),IOThF(400),
     +IOAF(400),IODF(400),IOTF1(150),IOThF1(150),IOAF1(150),
     +IODF1(150),IOTE(150),IOThE(150),IOAE(150),IODE(150),
     +IXTF(400),IXAF(400),IXDF(400),IXTF1(150),IXAF1(150),
     +IXDF1(150),IXTE(150),IXAE(150),IXDE(150),MEDF(20),
     +MEDE(20),MEDES(20),IedF(120),IOTsE(150),IOAsE(150),IODsE(150),
     +IedFTP(120)
C
      INTEGER*2 IREAD,IERR
C
      REAL*4 OTF(400),OThF(1000),OTF1(150),OThF1(1000),OTE(150),
     +       OThE(1000),XTF(400),XTF1(150),XTE(150),OTsE(150),
     +       HTAB(999),FTAB(999),NTAB(999)
C
      REAL*4 SCALED(45),GCONST(16),DTT(16),ftOF(400),ftOF1(150),
     +       ftOE(150),ftXF(400),ftXF1(150),ftXE(150),THF2(20),
     +       THF1(20),THE(20),THVAL(20),ftOsE(150)
      REAL*8 QPCOEF(121)
      CHARACTER*120 SYSDES
      CHARACTER*1 IPREF(120),QL(120),DL(120)
C
	COMMON /SAO/ IDFI,GCONST,Sysdes,IPREF,SCALED,IAF,
     +   DTT,IOTF,IOThF,IOAF,IODF,ftOF,IOTF1,IOThF1,IOAF1,IODF1,ftOF1,
     +   IOTE,IOThE,IOAE,IODE,ftOE,IXTF,IXAF,IXDF,ftXF,IXTF1,IXAF1,
     +   IXDF1,ftXF1,IXTE,IXAE,IXDE,ftXE,MEDF,MEDE,MEDES,THF2,THF1,
     +   THE,QPCOEF,THVAL,IedF,IOTsE,IOAsE,IODsE,ftOsE,
     +   OTF,OThF,OTF1,OThF1,OTE,OThE,XTF,XTF1,XTE,OTsE,
     +   HTAB,FTAB,NTAB,QL,DL,IedFTP
      REAL TRUEHGT,F,ELDEN,DF,F0
      equivalence (chaPREF,IPREF)
      data root /'../../miseta/digisonde/'/
      nprof = 0
      do i = 1,288
        rmxalt(i) = -1.0
      end do
      if (iyear .eq. 2004) return
      if (iyear .eq. 2003 .and. imon .gt. 11) return
c      if (iyear .eq. 2002 .and. imon .gt. 10) return
      iok = 0
      ione = 1
      call fnddoy(iyear,imon,iday,idoy)
      write (unit=cha4,fmt='(i4)') iyear
      write (unit=cha3,fmt='(i3.3)') idoy
      write (unit=cha4a,fmt='(2i2.2)') imon,iday
      if (isite .eq. 1) then
        filename = trim(cha80)//'JI91J_'//cha4//cha3//'.SAO'
      else if (isite .eq. 2) then
        filename = trim(cha80)//'THJ77_'//cha4//cha4a//'.SAO'
      else if (isite .eq. 3) then
        filename = trim(cha80)//'SMJ67_'//cha4//cha4a//'.SAO'
      else if (isite .eq. 4) then
        filename = trim(cha80)//'JM91J_'//cha4//cha3//'.SAO'
      else if (isite .eq. 5) then
        filename = trim(cha80)//'TMJ20_'//cha4//cha3//'.SAO'
      else if (isite .eq. 6) then
        filename = trim(cha80)//'TZJ2J_'//cha4//cha3//'.SAO'
      end if
      print *,filename
      inquire(file=filename,exist=lexist)
      if (lexist) then
        iok = 1
        print *,'file: ',filename
        open (25,file=filename,status='UNKNOWN')
5       continue
        EOF=.FALSE.
c        if (nprof .ne. 0) print *,'before READSAO',nprof
        CALL READSAO(TIME,EOF,IREAD,IERR)
c         print *,EOF,IERR
        if (EOF) go to 10
        if (IERR .NE. 0) then
          print *,'IERR .NE. 0'
          call syncfil(EOF)
          if (EOF) go to 10
          go to 5
        end if
        read (unit=chaPREF(3:6),fmt='(i4)') kyear
        read (unit=chaPREF(10:13),fmt='(2i2)') kmon,kday
        read (unit=chaPREF(14:15),fmt='(i2)') khr
        read (unit=chaPREF(16:17),fmt='(i2)') kmn
        read (unit=chaPREF(18:19),fmt='(i2)') ksc
c        print *,kyear,kmon,kday,khr,kmn,ksc,IDFI(53)
        if (kyear.eq.iyear .and. kmon.eq.imon .and. kday.eq.iday) then
          nprof = nprof + 1
          if (nprof .gt. 288) print *,'# profiles exceed 288'
c          print *,kyear,kmon,kday,khr,kmn,ksc,IDFI(53)
          write (18,*) kyear,kmon,kday,khr,kmn,ksc,IDFI(53)
          npts(nprof) = IDFI(53)
          xhr(nprof)  = khr
          xmn(nprof)  = kmn
          xsec(nprof) = ksc
          nn          = npts(nprof)
          dmax        = -1.0
          do is = 1,nn
            alt(nprof,is) = HTAB(is)
            freq(nprof,is) = NTAB(is)
            if (dmax .lt. freq(nprof,is)) then
              dmax = freq(nprof,is)
              rmxalt(nprof) = alt(nprof,is)
            end if
          end do
          write (18,fmt='(a17)') TIME
          write (18,fmt='(12f8.1)') (alt(nprof,is),is=1,nn)
          write (18,fmt='(12e8.3)') (freq(nprof,is),is=1,nn)
        end if
        go to 5
10      continue
        print *,'# profiles: ',nprof
        close (25)
      end if
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
C
C      SUBROUTINE READSAO(EOF,IDFI,GCONST,Sysdes,IPREF,SCALED,IAF,
C     +   DTT,IOTF,IOThF,IOAF,IODF,ftOF,IOTF1,IOThF1,IOAF1,IODF1,ftOF1,
C     +   IOTE,IOThE,IOAE,IODE,ftOE,IXTF,IXAF,IXDF,ftXF,IXTF1,IXAF1,
C     +   IXDF1,ftXF1,IXTE,IXAE,IXDE,ftXE,MEDF,MEDE,MEDES,THF2,THF1,
C     +   THE,QPCOEF,THVAL,IedF,IOTsE,IOAsE,IODsE,ftOsE,
C     +   OTF,OThF,OTF1,OThF1,OTE,OThE,XTF,XTF1,XTE,OTsE,
C     +   HTAB,FTAB,QL,DL,IedFTP,
C     +   IREAD,IERR)
c
c  Version 96050810
c
c  Input Variables:
C    Arrays to store SAO data
C    EOF      -   end of file check
C    IU       -   file unit number   (not used for pipe)
C    TIME     -   Measurement time in CHARACTER*17 format YYYY DDD HH:MM:SS
C   array     code    description
C             group
C    IDFI     --      data file index
C    GCONST        1       Geophysical constants
C    Sysdes        2       System description
C    IPREF         3       ionogram sounding settings
C    SCALED        4       scaled ionogram parameters
C    IAF           5       analysis flags
C    DTT           6       Doppler translation table
C    IOTF/OTF      7       O-trace F2 virtual height
C    IOThF/OThF    8       O-trace F2 true height
C    IOAF          9       O-trace F2 amplitudes
C    IODF         10       O-trace F2 Doppler numbers
C    ftOF         11       O-trace F2 frequency table
C    IOTF1/OTF1   12       O-trace F1 virtual height
C    IOThF1/OThF1 13       O-trace F1 true height
C    IOAF1        14       O-trace F1 amplitudes
C    IODF1        15       O-trace F1 Doppler numbers
C    ftOF1        16       O-trace F1 frequency table
C    IOTE/OTE     17       O-trace E  virtual height
C    IOThE/OThE   18       O-trace E  true height
C    IOAE         19       O-trace E  amplitudes
C    IODE         20       O-trace E  Doppler numbers
C    ftOE         21       O-trace E  frequency table
C    IXTF/XTF     22       X-trace F2 virtual height
C    IXAF         23       X-trace F2 amplitudes
C    IXDF         24       X-trace F2 Doppler numbers
C    ftXF         25       X-trace F2 frequency table
C    IXTF1/XTF1   26       X-trace F1 virtual height
C    IXAF1        27       X-trace F1 amplitudes
C    IXDF1        28       X-trace F1 Doppler numbers
C    ftXF1        29       X-trace F1 frequency table
C    IXTE/XTE     30       X-trace E  virtual height
C    IXAE         31       X-trace E  amplitudes
C    IXDE         32       X-trace E  Doppler numbers
C    ftXE         33       X-trace E  frequency table
C    MEDF         34       Median amplitude of F echo
C    MEDE         35       Median amplitude of E echo
C    MEDES        36       Median amplitude of Es echo
C    THF2         37       F2 layer true height parameters
C    THF1         38       F1 layer true height parameters
C    THE          39       E layer true height parameters
C    THVAL        40       Valley parameters from Polan and NhPc version 2.01
C    IedF         41       Edit Flags
C    THVAL        42       Valley parameters from NhPc version 3.01 or higher
C    IOTsE/OTsE   43       O-trace sporadic-E  virtual height
C    IOAsE        44       O-trace sporadic-E  amplitudes
C    IODsE        45       O-trace sporadic-E  Doppler numbers
C    ftOsE        46       O-trace sporadic-E  frequency table
c
c  Output Variables
C    Arrays with corresponding SAO data
c
c  Purpose:  READ SAO files with all versions
c
c  Revision Log
C     IDFI(80) is used as an indicator of the format of the data
C              in the SAO file
C     IDFI(80) = 0 --- SAO version 3.0 format
C     IDFI(80) = 1 --- SAO version 3.0 format with true height data
C                      format enhanced
C     IDFI(80) = 2 --- SAO version 4.0 format
C     IDFI(80) = 3 --- SAO version 4.0 format, oblique ionogram
C                      converted to vertical
C
C 08Nov01 T.Bullett
C  - Decoded time in the subroutine
C  - Zeroed the arrays before reading

C To-Do:  Rewrite to eliminate GOTO's

C**********************************************************************
      SUBROUTINE READSAO(TIME,EOF,IREAD,IERR)
C
      CHARACTER*17 TIME
      LOGICAL   EOF
C
      INTEGER*2 I,IREAD,IERR,IY
C
      INTEGER*2 IDFI(80),IAF(60),IOTF(400),IOThF(400),
     +IOAF(400),IODF(400),IOTF1(150),IOThF1(150),IOAF1(150),
     +IODF1(150),IOTE(150),IOThE(150),IOAE(150),IODE(150),
     +IXTF(400),IXAF(400),IXDF(400),IXTF1(150),IXAF1(150),
     +IXDF1(150),IXTE(150),IXAE(150),IXDE(150),MEDF(20),
     +MEDE(20),MEDES(20),IedF(120),IOTsE(150),IOAsE(150),IODsE(150),
     +IedFTP(120)
C
      REAL*4 OTF(400),OThF(1000),OTF1(150),OThF1(1000),OTE(150),
     +       OThE(1000),XTF(400),XTF1(150),XTE(150),OTsE(150),
     +       HTAB(999),FTAB(999),NTAB(999)
C
      REAL*4 SCALED(45),GCONST(16),DTT(16),ftOF(400),ftOF1(150),
     +       ftOE(150),ftXF(400),ftXF1(150),ftXE(150),THF2(20),
     +       THF1(20),THE(20),THVAL(20),ftOsE(150)
      REAL*8 QPCOEF(121)
      CHARACTER*120 Sysdes
      CHARACTER*1 IPREF(120),QL(120),DL(120)
C
      CHARACTER*12 FM1,FM2,FM3,FM4,FM5,FM6,FM7,FM8,FM9,FM10,FM11,FM12
C
	COMMON /SAO/ IDFI,GCONST,Sysdes,IPREF,SCALED,IAF,
     +   DTT,IOTF,IOThF,IOAF,IODF,ftOF,IOTF1,IOThF1,IOAF1,IODF1,ftOF1,
     +   IOTE,IOThE,IOAE,IODE,ftOE,IXTF,IXAF,IXDF,ftXF,IXTF1,IXAF1,
     +   IXDF1,ftXF1,IXTE,IXAE,IXDE,ftXE,MEDF,MEDE,MEDES,THF2,THF1,
     +   THE,QPCOEF,THVAL,IedF,IOTsE,IOAsE,IODsE,ftOsE,
     +   OTF,OThF,OTF1,OThF1,OTE,OThE,XTF,XTF1,XTE,OTsE,
     +   HTAB,FTAB,NTAB,QL,DL,IedFTP
C
c-----------------------------------------------------------------------
C  Zero all the data arrays.  Failing to do this causes problems under
C  various error conditions.
      EOF=.FALSE.
      TIME=''
      Sysdes=''

      DO I=1,80
         IDFI(I)=0
      ENDDO
C
      DO I=1,45
         SCALED(I)=0.0
      ENDDO
C
      DO I=1,16
         GCONST(I)=0.0
         DTT(I)=0.0
      ENDDO
C
      DO I=1,60
         IAF(I)=0
      ENDDO
C
      DO I=1,400
         IOTF(I)=0
         IOThF(I)=0
         IOAF(I)=0
         IODF(I)=0
         IXTF(I)=0
         IXAF(I)=0
         IXDF(I)=0
         OTF(I)=0.0
         ftOF(I)=0.0
      ENDDO
C
      DO I=1,150
         IOTF1(I)=0
         IOThF1(I)=0
         IOAF1(I)=0
         IODF1(I)=0
         IOTE(I)=0
         IOThE(I)=0
         IOAE(I)=0
         IODE(I)=0
         IXTF1(I)=0
         IXAF1(I)=0
         IXDF1(I)=0
         IXTE(I)=0
         IXAE(I)=0
         IXDE(I)=0
         IOTsE(I)=0
         IOAsE(I)=0
         IODsE(I)=0
         OTF1(I)=0.0
         OTE(I)=0.0
         XTF1(I)=0.0
         XTE(I)=0.0
         OTsE(I)=0.0
         ftOF1(I)=0.0
         ftOE(I)=0.0
         ftXF1(I)=0.0
         ftXE(I)=0.0
         ftOsE(I)=0.0
      ENDDO
C
      DO I=1,120
         IedF(I)=0
         IedFTP(I)=0
         QPCOEF(I)=0.0
         IPREF(I)=''
         QL(I)=''
         DL(I)=''
      ENDDO
C
      DO I=1,1000
         OThF(I)=0
         OThF1(I)=0
         OThE(I)=0
      ENDDO
C
      DO I=1,999
         HTAB(I)=0.0
         FTAB(I)=0.0
      ENDDO
C
      DO I=1,20
         MEDF(I)=0
         MEDE(I)=0
         MEDES(I)=0
         THF2(I)=0.0
         THF1(I)=0.0
         THE(I)=0.0
         THVAL(I)=0.0
      ENDDO
C
C
C ----
C...formats
C
 100  FORMAT (40I3)
      IERR=1
C
    1 CONTINUE
C...data file index
C     The data file index integers take two lines.
      READ(25,100,ERR=2,END=9) (IDFI(I),I=1,80)
      GOTO 3
    2 CONTINUE
      READ(25,'(A120)',END=9) SYSDES
      GOTO 1
C
    3 CONTINUE
      IF(IDFI(1).GT.0.AND.IDFI(1).LT.17) GOTO 4
      GOTO 99
C
    4 CONTINUE
      IERR=0
C
C     Formats of the elements vary with version number of the file.
      IF(IDFI(80).eq.0) THEN  !  Version 3 (and lower) SAO data
        WRITE(FM1,'(4X,A8)')  '(40I3)'
        WRITE(FM2,'(2X,A10)') '(16F7.3)'
        WRITE(FM3,'(4X,A8)')  '(A120)'
        WRITE(FM4,'(3X,A9)')  '(120A1)'
        WRITE(FM5,'(2X,A10)') '(15F8.3)'
        WRITE(FM6,'(4X,A8)')  '(60I2)'
        WRITE(FM7,'(3X,A9)')  '(120I1)'
        WRITE(FM8,'(2X,A10)') '(20F6.3)'
        WRITE(FM9,'(A12)')    '(13E9.4E1)'
        WRITE(FM10,'(3X,A8)') '(60I2)'
      ENDIF
C
      IF(IDFI(80).eq.1) THEN  ! Version 3 with enhanced true height data
        WRITE(FM1,'(4X,A8)')  '(40I3)'
        WRITE(FM2,'(2X,A10)') '(16F7.3)'
        WRITE(FM3,'(4X,A8)')  '(A120)'
        WRITE(FM4,'(3X,A9)')  '(120A1)'
        WRITE(FM5,'(2X,A10)') '(15F8.3)'
        WRITE(FM6,'(4X,A8)')  '(60I2)'
        WRITE(FM7,'(3X,A9)')  '(120I1)'
        WRITE(FM8,'(2X,A10)') '(20F6.3)'
        WRITE(FM9,'(A12)')    '(10E11.6E1)' ! <--- true height data
        WRITE(FM10,'(3X,A8)') '(60I2)'
      ENDIF
C
      IF(IDFI(80).GE.2) THEN                !  Version 4.00 or higher
        WRITE(FM1,'(2X,A10)') '(15F8.3)'    ! <--- h' and z
        WRITE(FM2,'(2X,A10)') '(16F7.3)'
        WRITE(FM3,'(4X,A8)')  '(A120)'
        WRITE(FM4,'(3X,A9)')  '(120A1)'     ! <--- preface
        WRITE(FM5,'(2X,A10)') '(15F8.3)'
        WRITE(FM6,'(4X,A8)')  '(60I2)'
        WRITE(FM7,'(3X,A9)')  '(120I1)'
        WRITE(FM8,'(2X,A10)') '(15F8.3)'    ! <--- frequency table
        WRITE(FM9,'(A12)')    '(10E11.6E1)' ! <--- true height data
        WRITE(FM10,'(3X,A8)') '(40I3)'
        WRITE(FM11,'(A12)')   '(15E8.3E1)'
        WRITE(FM12,'(A11)')   '(6E20.12)'
      ENDIF
C
C...Geophysical constants -- Code 1
      IF(IDFI(1).GT.0) READ(25,FM2,END=9,ERR=99)
     +                      (GCONST(I),I=1,IDFI(1))
c
C...system description -- Code 2
      IF(IDFI(2).GT.0) READ(25,FM3,END=9,ERR=99) Sysdes
c
C...ionogram sounding settings (preface) -- Code 3
      IF(IDFI(3).GT.0) READ(25,FM4,END=9,ERR=99)
     +                      (IPREF(I),I=1,IDFI(3))
C
C
C Decode the time out of the preface.  Note the format is also version-dependent
C All IPREF(I) in all sao versions are read from the SAO file with
C    format fm4='(120A1)'
C BUT the date, etc. are not in the same part of the preface in all versions:
C    for example,in older versions the preface starts with the 2-digit year;
C    the preface in version 4.2 starts with a 2-letter code followed by the
C    4-digit year...
C    Also, in the newer preface, the characters in positions 10-13 are month and day
C    This info is absent from the older format.
C
      IF (IDFI(80).GE.2) THEN
         WRITE(TIME,120) (IPREF(I),I=3,9),(IPREF(I),I=14,19)
      ELSE
C        Y2K issue:  1980/2080 ambiguity
         WRITE(TIME,'(2I1)') IPREF(1), IPREF(2)
         READ(TIME, *) IY
         IF(IY.LT.80) then
            IY=20
         ELSE
            IY=19
         ENDIF
         WRITE(TIME,121) IY,(IPREF(I),I=1,11)
      ENDIF
C     TIME format of YYYY DDD HH:MM:SS
 120  FORMAT (4A1,' ',3A1,' ',2A1,':',2A1,':',2A1)
 121  FORMAT (I2.2,2A1,' ',3A1,' ',2A1,':',2A1,':',2A1)
C
C
C
C...scaled ionogram parameters --  code 4
      IF(IDFI(4).GT.0) READ(25,FM5,END=9,ERR=99)
     +                      (SCALED(I),I=1,IDFI(4))
C
C...ARTIST analysis flags  --   code 5
      IF(IDFI(5) .GT.0) READ(25,FM6,END=9,ERR=99)
     +                      (IAF(I),I=1,IDFI(5))
C
C...Doppler translation table  --  code 6
      IF(IDFI(6).GT.0) READ(25,FM2,END=9,ERR=99)
     +                      (DTT(I),I=1,IDFI(6))
C
C...O-trace F2 points   --   code 7
C...virtual height
      IF(IDFI(7).GT.0) THEN
        IF(IDFI(80).GE.2)THEN
          READ(25,FM1,END=9,ERR=99) (OTF(I),I=1,IDFI(7))  ! SAO V4.0
          DO I=1,IDFI(7)
          IOTF(I)=OTF(I)
          ENDDO
        ELSE
          READ(25,FM1,END=9,ERR=99) (IOTF(I),I=1,IDFI(7)) ! SAO V3.0
                                                          ! and lower
          DO I=1,IDFI(7)
          OTF(I)=IOTF(I)
          ENDDO
        ENDIF
      ENDIF
c
C...true height   --   code 8
      IF(IDFI(8).GT.0) then
        IF(IDFI(80).GE.2)then
          READ(25,FM1,END=9,ERR=99) (OThF(I),I=1,IDFI(8))  ! SAO V4.0
        ELSE
          READ(25,FM1,END=9,ERR=99) (IOThF(I),I=1,IDFI(8)) ! SAO V3.0
                                                           ! and lower
        ENDIF
      ENDIF
c
C...amplitudes  --  code 9
      IF(IDFI(9).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IOAF(I),I=1,IDFI(9))
c
C...Doppler numbers   --   code 10
      IF(IDFI(10).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IODF(I),I=1,IDFI(10))
c
C...frequency table   --   code 11
      IF(IDFI(11).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftOF(I), I=1,IDFI(11))
C
C...O-trace F1 points
C...virtual height    --   code 12
      IF(IDFI(12).GT.0) then
        IF(IDFI(80).GE.2)then
         READ(25,FM1,END=9,ERR=99) (OTF1(I),I=1,IDFI(12))  ! SAO V4.0
         DO I=1,IDFI(12)
            IOTF1(I)=OTF1(I)
         ENDDO
        ELSE
         READ(25,FM1,END=9,ERR=99) (IOTF1(I),I=1,IDFI(12)) ! SAO V3.0
                                                           ! and lower
         DO I=1,IDFI(12)
             OTF1(I)=IOTF1(I)
         ENDDO
        ENDIF
      ENDIF
c
C...true height       --   code 13
      IF(IDFI(13).GT.0) then
        IF(IDFI(80).GE.2)then
        READ(25,FM1,END=9,ERR=99) (OThF1(I),I=1,IDFI(13))  ! SAO V4.0
        ELSE
        READ(25,FM1,END=9,ERR=99) (IOThF1(I),I=1,IDFI(13)) ! SAO V3.0
                                                           ! and lower
        ENDIF
      ENDIF
c
C...amplitudes        --   code 14
      IF(IDFI(14).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IOAF1(I),I=1,IDFI(14))
c
C...Doppler number    --   code 15
      IF(IDFI(15).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IODF1(I),I=1,IDFI(15))
c
C...frequency table   --   code 16
      IF(IDFI(16).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftOF1(I), I=1,IDFI(16))
C
C...O-trace E points
C...virtual heights   --   code 17
      IF(IDFI(17).GT.0) then
        IF(IDFI(80).GE.2)then
          READ(25,FM1,END=9,ERR=99) (OTE(I),I=1,IDFI(17))  ! SAO V4.0
          DO I=1,IDFI(17)
             IOTE(I)=OTE(I)
          ENDDO
        ELSE
          READ(25,FM1,END=9,ERR=99) (IOTE(I),I=1,IDFI(17)) ! SAO V3.0
                                                           ! and lower
          DO I=1,IDFI(17)
             OTE(I)=IOTE(I)
          ENDDO
        ENDIF
      ENDIF
c
C...true height       --   code 18
      IF(IDFI(18).GT.0) then
        IF(IDFI(80).GE.2)then
         READ(25,FM1,END=9,ERR=99) (OThE(I),I=1,IDFI(18))  ! SAO V4.0
        ELSE
         READ(25,FM1,END=9,ERR=99) (IOThE(I),I=1,IDFI(18)) ! SAO V3.0
                                                           ! and lower
        ENDIF
      ENDIF
c
C...amplitudes        --   code 19
      IF(IDFI(19).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IOAE(I),I=1,IDFI(19))
c
C...Doppler numbers   --   code 20
      IF(IDFI(20).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IODE(I),I=1,IDFI(20))
c
C...frequency table   --   code 21
      IF(IDFI(21).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftOE(I), I=1,IDFI(21))
C
C...X-trace F2 points
C...virtual heights   --   code 22
      IF(IDFI(22).GT.0) then
        IF(IDFI(80).GE.2)then
          READ(25,FM1,END=9,ERR=99) (XTF(I),I=1,IDFI(22))  ! SAO V4.0
        ELSE
          READ(25,FM1,END=9,ERR=99) (IXTF(I),I=1,IDFI(22)) ! SAO V3.0
                                                          ! and lower
        ENDIF
      ENDIF
c
C...amplitudes        --   code 23
      IF(IDFI(23).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IXAF(I),I=1,IDFI(23))
c
C...Doppler numbers   --   code 24
      IF(IDFI(24).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IXDF(I),I=1,IDFI(24))
c
C...frequency table   --   code 25
      IF(IDFI(25).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftXF(I),I=1,IDFI(25))
C
C...X-trace F1 points
C...virtual heights   --   code 26
      IF(IDFI(26).GT.0) then
        IF(IDFI(80).GE.2)then
         READ(25,FM1,END=9,ERR=99) (XTF1(I),I=1,IDFI(26))  ! SAO V4.0
        ELSE
         READ(25,FM1,END=9,ERR=99) (IXTF1(I),I=1,IDFI(26)) ! SAO V3.0
                                                           ! and lower
        ENDIF
      ENDIF
c
C...amplitudes        --   code 27
      IF(IDFI(27).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IXAF1(I),I=1,IDFI(27))
c
C...Doppler numbers   --   code 28
      IF(IDFI(28).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IXDF1(I),I=1,IDFI(28))
c
C...frequency table   --   code 29
      IF(IDFI(29).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftXF1(I),I=1,IDFI(29))
C
C...X-trace E points
C...virtual heights   --  code 30
      IF(IDFI(30).GT.0) then
        IF(IDFI(80).GE.2)then
          READ(25,FM1,END=9,ERR=99) (XTE(I),I=1,IDFI(30))  ! SAO V4.0
        ELSE
          READ(25,FM1,END=9,ERR=99) (IXTE(I),I=1,IDFI(30)) ! SAO V3.0
                                                           ! and lower
        ENDIF
      ENDIF
c
C...amplitudes        --   code 31
      IF(IDFI(31).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IXAE(I),I=1,IDFI(31))
c
C...Doppler numbers   --   code 32
      IF(IDFI(32).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IXDE(I),I=1,IDFI(32))
c
C...frequency table   --   code 33
      IF(IDFI(33).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftXE(I),I=1,IDFI(33))
C
C...median amplitude of F echo   --   code 34
      IF(IDFI(34).GT.0) READ(25,FM6,END=9,ERR=99)
     +                      (MEDF(I),I=1,IDFI(34))
C...median amplitude of E echo   --   code 35
      IF(IDFI(35).GT.0) READ(25,FM6,END=9,ERR=99)
     +                      (MEDE(I),I=1,IDFI(35))
C...median amplitude of Es echo  --   code 36
      IF(IDFI(36).GT.0) READ(25,FM6,END=9,ERR=99)
     +                      (MEDES(I),I=1,IDFI(36))
C
C...F2 layer true height parameters   --   code 37
      IF(IDFI(37).GT.0) READ(25,FM9,END=9,ERR=99)
     +                      (THF2(I),I=1,IDFI(37))
c
C...F1 layer true height parameters   --   code 38
      IF(IDFI(38).GT.0) READ(25,FM9,END=9,ERR=99)
     +                      (THF1(I),I=1,IDFI(38))
C...E layer true height parameters    --   code 39
      IF(IDFI(39).GT.0) READ(25,FM9,END=9,ERR=99)
     +                      (THE(I),I=1,IDFI(39))
C
C...valley parameters from Polan and NhPc version 2.01
      IF(IDFI(40).GT.0) THEN
        IF(IDFI(80).LT.2) THEN
        READ(25,FM9,END=9,ERR=99)  (THVAL(I),I=1,IDFI(40))
        ELSE
        READ(25,FM12,END=9,ERR=99) (QPCOEF(I),I=1,IDFI(40))
        ENDIF
      ENDIF
C
C...edit flags
C...NOTE: FOR OLD DATA, THIS INCLUDES BOTH THE CHARACTERISTCS FLAG
C         AND THE TRACE+PROFILE FLAG
      IF(IDFI(41).GT.0) READ(25,FM7,END=9,ERR=99) (IedF(I),I=1,IDFI(41))
c
C...Valley parameters from NhPc version 3.01 and greater Sept. 1993
      IF(IDFI(42).GT.0) READ(25,FM9,END=9,ERR=99)
     +                      (THVAL(I),I=1,IDFI(42))
c
C...O-trace sporadic-E
C...virtual heights
      IF(IDFI(43).GT.0) then
        IF(IDFI(80).GE.2)then
         READ(25,FM1,END=9,ERR=99) (OTsE(I),I=1,IDFI(43))  ! SAO V4.0
        ELSE
         READ(25,FM1,END=9,ERR=99) (IOTsE(I),I=1,IDFI(43)) ! SAO V3.0
                                                           ! and lower
        ENDIF
      ENDIF
c
C...amplitudes
      IF(IDFI(44).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IOAsE(I),I=1,IDFI(44))
c
C...Doppler numbers
      IF(IDFI(45).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IODsE(I),I=1,IDFI(45))
c
C...frequency table
      IF(IDFI(46).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftOsE(I),I=1,IDFI(46))
c
C...O-trace - Auroral E layer
C...virtual heights
      IF(IDFI(47).GT.0) then
        IF(IDFI(80).GE.2)then
         READ(25,FM1,END=9,ERR=99) (OTsE(I),I=1,IDFI(47))  ! SAO V4.0
         DO I=1,IDFI(47)
         IOTsE(I)=OTsE(I)
         ENDDO
        ELSE
         READ(25,FM1,END=9,ERR=99) (IOTsE(I),I=1,IDFI(47)) ! SAO V3.0
                                                           ! and lower
         DO I=1,IDFI(47)
         OTsE(I)=IOTsE(I)
         ENDDO
        ENDIF
      ENDIF
c
C...amplitudes
      IF(IDFI(48).GT.0) READ(25,FM10,END=9,ERR=99)
     +                      (IOAsE(I),I=1,IDFI(48))
c
C...Doppler numbers
      IF(IDFI(49).GT.0) READ(25,FM7,END=9,ERR=99)
     +                      (IODsE(I),I=1,IDFI(49))
c
C...frequency table
      IF(IDFI(50).GT.0) READ(25,FM8,END=9,ERR=99)
     +                      (ftOsE(I),I=1,IDFI(50))
c
C...N(h) Tabulation
      IF(IDFI(51).GT.0) THEN
        READ(25,FM11,END=9,ERR=99) (HTAB(I),I=1,IDFI(51))
        READ(25,FM11,END=9,ERR=99) (FTAB(I),I=1,IDFI(52))
        READ(25,FM11,END=9,ERR=99) (NTAB(I),I=1,IDFI(53))
      ENDIF
c
C...Qualifying Letters
      IF(IDFI(54).GT.0) READ(25,FM4,END=9,ERR=99) (QL(I),I=1,IDFI(54))
C...Descriptive Letters
      IF(IDFI(55).GT.0) READ(25,FM4,END=9,ERR=99) (DL(I),I=1,IDFI(55))
C...Edit Flags - Traces and Profile
      IF(IDFI(56).GT.0) THEN
        READ(25,FM7,END=9,ERR=99) (IedFTP(I),I=1,IDFI(56))
      ENDIF
c
      IREAD=1
      EOF = .FALSE.
      RETURN
    9 EOF = .TRUE.
      RETURN
C
   99 CONTINUE
      IERR=1
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
	REAL FUNCTION ELDEN(F)
C	Convert plasma frequency (MHz) into electron density (x10E5).
	REAL F
	ELDEN = F*F/8.1
	RETURN
	END
C--------1---------2---------3---------4---------5---------6---------7-V
	REAL FUNCTION TRUEHGT(F)
C
C	Using the /SAO/ coefficients for the true height, calculate
C	the TRUEHGT [km] of the profile at the given frequency F [MHz].
C
C 07Dec99 TWB  - Modify for SAO v4.2
C
C     Note: This does not reproduce any valley or topside.  To do so would
C           require significant shift from viewing this as H(F) to N(h).
C           Maybe the next version.
C
C	The method of calculating the height Z is:
C                       M
C    Z=DUM(M+1)+SQRT(XM)+SUM DUM(I)*TSTAR(XM,I)
C                      I=0
C   WHERE A=COEFFICIENTS OF POLYNOMIAL FUNCTION
C         XM=(ALOG(FN/FOF2))/(ALOG(FOE/FOF2))
C         TSTAR=SHIFTED CHEBYSHEV FUNCTION
C   INPUT: DUM=COEFFICIENTS
C          FN=PLASMA FREQ
C
C SAO Format common block
      INTEGER*2 IDFI(80),IAF(60),IOTF(400),IOTHF(400),
     +  IOAF(400),IODF(400),IOTF1(150),IOThF1(150),IOAF1(150),
     +  IODF1(150),IOTE(150),IOThE(150),IOAE(150),IODE(150),
     +  IXTF(400),IXAF(400),IXDF(400),IXTF1(150),IXAF1(150),
     +  IXDF1(150),IXTE(150),IXAE(150),IXDE(150),MEDF(20),
     +  MEDE(20),MEDES(20),IEDF(120),IOTSE(150),IOASE(150),
     +  IODSE(150),IEDFTP(120)
C
      REAL*4 OTF(400),OTHF(1000),OTF1(150),OTHF1(1000),OTE(150),
     +       OTHE(1000),XTF(400),XTF1(150),XTE(150),OTsE(150),
     +       HTAB(999),FTAB(999),NTAB(999)
C
      REAL*4 SCALED(45),GCONST(16),DTT(16),FTOF(400),FTOF1(150),
     +       FTOE(150),FTXF(400),FTXF1(150),FTXE(150),THF2(20),
     +       THF1(20),THE(20),THVAL(20),FTOSE(150)
      REAL*8 QPCOEF(121)
      CHARACTER*120 SYSDES
      CHARACTER*1 IPREF(120),QL(120),DL(120)
C
	COMMON /SAO/ IDFI,GCONST,Sysdes,IPREF,SCALED,IAF,
     +   DTT,IOTF,IOThF,IOAF,IODF,ftOF,IOTF1,IOThF1,IOAF1,IODF1,ftOF1,
     +   IOTE,IOThE,IOAE,IODE,ftOE,IXTF,IXAF,IXDF,ftXF,IXTF1,IXAF1,
     +   IXDF1,ftXF1,IXTE,IXAE,IXDE,ftXE,MEDF,MEDE,MEDES,THF2,THF1,
     +   THE,QPCOEF,THVAL,IedF,IOTsE,IOAsE,IODsE,ftOsE,
     +   OTF,OThF,OTF1,OThF1,OTE,OThE,XTF,XTF1,XTE,OTsE,
     +   HTAB,FTAB,NTAB,QL,DL,IedFTP
C COEFS common block
C	Coefficients for reconstructing the true height profile.
C
	INTEGER NFQ,NCOEF
	REAL A(8),AE(3),AF(7),AF1(7),ATE,ATF,ATF1,HBOTM,FSTART,FEND
	COMMON/COEFS/A,AE,AF,AF1,ATE,ATF,ATF1,
     +		       HBOTM,NFQ,NCOEF,FSTART,FEND
C
	INTEGER I
C
C
C       Default null value
        TRUEHGT = 0.0
C
C	Use the frequency F to select the layer to use
	IF ((F.LT.0.0).OR.(F.GT.SCALED(1))) THEN
C	   F is above or below the trace
	   TRUEHGT = 0.0
	   RETURN
C	E-Layer
	ELSE IF ((IDFI(39).GT.0).AND.
     +        (F.GE.THE(1)).AND.(F.LE.THE(2))) THEN
C	      Use the coefficients for the E layer
C             What happens here when there is a modeled or parabolic E??
	   NCOEF = 3
	   FSTART = THE(1)
	   FEND   = THE(2)
	   A(8)   = THE(3)
	   DO I = 1, NCOEF
	      A(I) = THE(I+4)
	      AE(I) = A(I)
           ENDDO
	   CALL PROF(F,TRUEHGT)
	ELSE IF ((IDFI(39).EQ.0).AND.(F.LE.SCALED(9))) THEN
C	   Parabolic E model using Hmax and Ym
	   TRUEHGT = SCALED(15) -
     +      SCALED(16)*SQRT(1.0 - (F/SCALED(9))**2)
C	F1 Layer
	ELSE IF ((IDFI(38).GT.0).AND.
     +   (F.GE.THF1(1)).AND.(F.LE.THF1(2))) THEN
	   NCOEF = 5
	   FSTART = THF1(1)
	   FEND   = THF1(2)
	   A(8)   = THF1(3)
	   DO I = 1, NCOEF
	      A(I) = THF1(I+4)
	      AF1(I) = A(I)
           ENDDO
	   CALL PROF(F,TRUEHGT)
C	F2 Layer
	ELSE IF ((IDFI(37).GT.0).AND.
     +   (F.GE.THF2(1)).AND.(F.LE.THF2(2))) THEN
	   NCOEF = 5
	   FSTART = THF2(1)
	   FEND   = THF2(2)
	   A(8)   = THF2(3)
	   DO I = 1, NCOEF
	      A(I) = THF2(I+4)
	      AF(I) = A(I)
           ENDDO
	   CALL PROF(F,TRUEHGT)
	ELSE
C	   There are no true height coefficients
	   TRUEHGT = 0.0
	   RETURN
	ENDIF
	RETURN
	END
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE PROF(FN,H)
C...FROM THE ASSUMED INITIAL PROFILE, CALCULATE
C    H ACCORDING TO THE EQUATION
C                       M
C    Z=DUM(M+1)+SQRT(XM)+SUM DUM(I)*TSTAR(XM,I)
C                      I=0
C   WHERE A=COEFFICIENTS OF POLYNOMIAL FUNCTION
C         XM=(ALOG(FN/FOF2))/(ALOG(FOE/FOF2))
C         TSTAR=SHIFTED CHEBYSHEV FUNCTION
C   INPUT: DUM=COEFFICIENTS
C          FN=PLASMA FREQ
C   OUTPUT: H
C.................................................
C
C	Coefficients for reconstructing the true height profile.
C
	INTEGER NFQ,NCOEF
	REAL A(8),AE(3),AF(7),AF1(7),ATE,ATF,ATF1,HBOTM,FSTART,FEND
	COMMON/COEFS/A,AE,AF,AF1,ATE,ATF,ATF1,
     +		       HBOTM,NFQ,NCOEF,FSTART,FEND
C
C
	REAL Y1,YS,XM,TSTAR,FN,H
	INTEGER I
C
C...BELOW IS FOR E- AND F- REGION POLYNOMIAL FITS
      H=0.
C...CHECK THE START FREQUENCY
      IF(FN.GT.FSTART) THEN
C... AND THE END FREQUENCY
         IF(FN.LT.FEND)THEN
            Y1=ALOG(FN/FEND)
            YS=ALOG(FSTART/FEND)
            XM=Y1/YS
            IF(XM.LT.0.) THEN
               WRITE(*,'(A,3F7.1)')' *****XM < 0. IN PROF,FN,FSTART,
     +         FEND=',FN,FSTART,FEND
            XM=0.
            ENDIF
C222
         ELSE
            XM=0.
C222
         ENDIF
C...CALCULATE THE TRUE HEIGHT
         DO 10 I=1,NCOEF
   10    H=H+A(I)*TSTAR(XM,I)
         H=H*SQRT(XM)
         H=H+A(8)
C111
      ENDIF
C
  300 CONTINUE
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      REAL FUNCTION TSTAR(CD,N)
C...TSTAR CALCULATE SHIFTED CHEVBYSHEV FUNCTION
C   INPUT: CD=LN(FN/FOF2)/LN(FOE/FOF2)
C          N=INDEX OF POLYNOMIAL
C    C=COEFFICIENTS OF THE TAYLOR DEVELOPMENT OF TSTAR
C       FUNCTION
C,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
C
      REAL C(8,8),CD
	INTEGER J,N
C
      DATA C(1,1),C(1,2),C(1,3),C(1,4),C(1,5),C(1,6),C(1,7),C(1,8)
     +/1.,7*0./
C
      DATA C(2,1),C(2,2),C(2,3),C(2,4),C(2,5),C(2,6),C(2,7),C(2,8)
     +/2.,-1.,6*0./
C
      DATA C(3,1),C(3,2),C(3,3),C(3,4),C(3,5),C(3,6),C(3,7),C(3,8)
     +/8.,-8.,1.,5*0./
C
      DATA C(4,1),C(4,2),C(4,3),C(4,4),C(4,5),C(4,6),C(4,7),C(4,8)
     +/32.,-48.,18.,-1.,4*0./
C
      DATA C(5,1),C(5,2),C(5,3),C(5,4),C(5,5),C(5,6),C(5,7),C(5,8)
     +/128.,-256.,160.,-32.,1.,3*0./
C
      DATA C(6,1),C(6,2),C(6,3),C(6,4),C(6,5),C(6,6),C(6,7),C(6,8)
     +/512.,-1280.,1120.,-400.,50.,-1.,2*0./
C
      DATA C(7,1),C(7,2),C(7,3),C(7,4),C(7,5),C(7,6),C(7,7),C(7,8)
     +/2048.,-6144.,6912.,-3584.,840.,-72.,1.,0./
C
      DATA C(8,1),C(8,2),C(8,3),C(8,4),C(8,5),C(8,6),C(8,7),C(8,8)
     +/8192.,-28672.,39424.,-26880.,9408.,-1568.,98.,-1./
C...FOR THE N=1 CONDITION - TSTAR EQUALS THE TAYLOR COEFFICIENT
      TSTAR=C(N,1)
      IF (N .EQ. 1) GO TO 20
C...FOR N>1 CALCULATE TSTAR
      DO 10 J=2,N
   10 TSTAR=TSTAR*CD+C(N,J)
      RETURN
   20 CONTINUE
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine syncfil(EOF)
      character*9 cha9
      character*120 cha120
      LOGICAL   EOF
      data cha9 /'  5  1 77'/
1     continue
      read (25,2,end=10,err=10) cha120
2     format (a120)
      if (cha120(1:9) .eq. cha9) then
        print *,'equal to ',cha9
c        pause
        backspace (25)
        go to 3
      end if
      go to 1
3     continue
      return
10    EOF = .true.
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
