      program digi2plot
c        This program reads digisonde data that have been previously
c        hand scaled and makes displays of color-coded densities
c        models/llions_v1.5a
c        by CEV April 21, 2006
      character*2  cha2a
      character*4  chayear
      character*9  cham(12)
      character*18 chadate
      character*19 digivel
      character*80 cha80
      integer nmon(12)
      common /commdat/  chadate
      common /cmm12frm/ i12frmt
      common /cmmsite/  isite,ibott
      common /cmcha80/  cha80
      data      cham /'  January',' February','    March','    April',
     &    '      May','     June','     July','   August','September',
     &    '  October',' November',' December'/
      data nmon /31,28,31,30,31,30,31,31,30,31,30,31/
      data digivel /'digivelaaaaxxyy.dat'/
      open (8,file='tape8',status='UNKNOWN')
      open (18,file='tape18',status='UNKNOWN')
      open (28,file='options2digi',status='UNKNOWN')
      read (28,fmt='(i1)') idrive
      if (idrive .eq. 0) then
        print *,'type site: Jicamarca=1, Qaanaaq=2, Sonde=3, JVIPIR = 4'
        read *,isite
        print *,'only bottomside, Y=1, N=0'
        read *,ibott
        print *,'type year as 2002'
        read *,kyear
        print *,'type month as MM'
        read *,kmonth
        print *,'type day as DD'
        read *,kday
        print *,'format 24 hr = 1 or 12,12 format = 2, only 16-24 = 3'
        read *,i12frmt
        print *,'type of plot: color ionograms = 1; profiles =2'
        read *,itypeplt
      else if (idrive .eq. 1) then
        read (28,fmt='(i2)') isite
        read (28,fmt='(i2)') ibott
        read (28,fmt='(i4)') kyear
        read (28,fmt='(i2)') kmonth
        read (28,fmt='(i2)') kday
        read (28,fmt='(i1)') i12frmt
        read (28,fmt='(i1)') itypeplt
        read (28,fmt='(a80)') cha80
        print *,'site 2B plotted',isite
        print *,'bottomside or N',ibott
        print *,'Year 2B plotted',kyear
        print *,'Month 2B ploted',kmonth
        print *,'day toB plotted',kday
        print *,'24 or 12 hours:',i12frmt
        print *,'Name of file2R ',trim(cha80)
      end if
      write (unit=digivel(8:15),fmt='(i4,i2.2,i2.2)') kyear,kmonth,kday
      print *,digivel
      open (38,file=digivel,status='UNKNOWN')
      nday = nmon(kmonth)
      write (unit=cha2a,fmt='(i2.2)') kday
      write (unit=chayear,fmt='(i4)') kyear
      chadate = cham(kmonth)//' '//cha2a//', '//chayear
      call readdigi(kyear,kmonth,kday)
      if (itypeplt .eq. 1) then
        call pltmeden(kyear,kmonth,kday)
      else if (itypeplt .eq. 2) then
        call pltmeprf(kyear,kmonth,kday)
      end if
      close (38)
      stop
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine pltmeden(kyear,kmonth,kday)
      character*2  cha2a
      character*4  chayear
      character*9  cham(12)
      character*18 chadate
      common /commdat/ chadate
      dimension    alt(288,999),freq(288,999),npts(288),xhr(288),
     &  xmn(288),xsec(288)
      common   /c22data/ alt,freq,npts,nprof,xhr,xmn,xsec
      dimension    rmxalt(288)
      common /cmmaxalt/ rmxalt
      dimension dens(999),altit(999)
      common /cmm12frm/ i12frmt
      dimension xden1(288),xden2(576),xtim1(288),xtim2(576),xalt1(288),
     & xalt2(576)
      common /cmmpeaks/ xden1,xden2,xtim1,xtim2,xalt1,xalt2,nnprf1,
     &  nnprf2
      common /cmmsite/  isite,ibott
      data      cham /'  January',' February','    March','    April',
     &    '      May','     June','     July','   August','September',
     &    '  October',' November',' December'/
      CALL INITIALIZE(1)
      call frmxden
      x900 = 900.0 - 400.0*float(ibott)
      write (unit=cha2a,fmt='(i2.2)') kday
      write (unit=chayear,fmt='(i4)') kyear
      chadate = cham(kmonth)//' '//cha2a//', '//chayear
      call wrtsymb(1.0,1.03,16,chadate,0,3,1)
      do j = 1,nprof
        xdnmax = 0.0
        if (npts(j) .eq. 0) go to 3
        do i = 1,npts(j)
          dens(i) = alog10(freq(j,i))
          altit(i) = alt(j,i)
          if (xdnmax .lt. freq(j,i)) then
            xdnmax = freq(j,i)
            ifpeak = i
          end if
        end do
        xden1(j) = xdnmax
        xtim1(j) = xhr(j)*60.0*60.0 + xmn(j)*60.0 + xsec(j)
        xalt1(j) = alt(j,ifpeak)
        t = 0.0
        x24 = 24.0
        if (i12frmt .eq. 2) t = 0.5
        if (i12frmt .eq. 3) t = -2.0
        if (i12frmt .eq. 3) x24 = 8.0
        if (i12frmt .eq. 4) t = 0.333
        if (i12frmt .eq. 4) x24 = 6.0
        x1 = xhr(j)/x24 + xmn(j)/60.0/x24 + xsec(j)/60.0/60.0/x24 + t
        t1 = xhr(j)*60.0*60.0 + xmn(j)*60.0 + xsec(j)
        t2 = 24.0*60.0*60.0
        if (j .lt. nprof) t2=xhr(j+1)*60.0*60.0+xmn(j+1)*60.0+xsec(j+1)
        if (j .eq. nprof) t2 = t1 + tsep0
        tsep = 15.0
        if ((t2-t1) .lt. 310.0) tsep = 5.0
c          ***   to make profiles only 5 min (may/2008)
        tsep = 5.0
        if (j .eq. 1) tsep0 = tsep
        if (j .eq. nprof) tsep = tsep0
        if (ibott .eq. 0) iend = npts(j)-1
        if (ibott .eq. 1) iend = ifpeak-1
        do i = 2,iend
          if (altit(i-1) .gt. 100 .and. altit(i+1) .lt. 1060.0) then
            icol = (dens(i) - 3.0)/3.5*100.0
            if (icol .lt. 1) icol = 1
            if (icol .lt. 1) go to 1
            if (icol .gt. 99) icol = 99
            y0 = (altit(i) - 100.0)/x900
            y1 = y0 - (altit(i) - altit(i-1))/2.0/x900
            y2 = y0 + (altit(i+1) - altit(i))/2.0/x900
            if (y2 .gt. 1.0) y2 = 1.0
            x2 = x1 + tsep/60.0/x24
            if (x1 .lt. 1.0 .and. x1 .gt. 0.0) then
              call pixel2(x1,y1,x2,y2,icol)
            end if
          end if
1         continue
        end do
3       continue
      end do
C    ****    plot PEAK altitude of F layer for each profile    ****    V
      n1 = nprof
      do j = 1,nprof
        t1 = xhr(j)*60.0*60.0 + xmn(j)*60.0 + xsec(j)
        t2 = 24.0*60.0*60.0
        if (j .lt. nprof) t2=xhr(j+1)*60.0*60.0+xmn(j+1)*60.0+xsec(j+1)
        tsep = 15.0
        if ((t2-t1) .lt. 310.0) tsep = 5.0
        t = 0.0
        if (i12frmt .eq. 2) t = 0.5
        if (i12frmt .eq. 3) t = -2.0
        if (i12frmt .eq. 4) t = 0.333
        x1 = xhr(j)/x24 + xmn(j)/60.0/x24 + xsec(j)/60.0/60.0/x24 + t
        x2 = x1 + tsep/60.0/x24
        y1 = (rmxalt(j) - 100.0)/x900
        if (rmxalt(j) .gt. 100.0 .and. x1.lt.1.0 .and. x1.gt.0.0) then
          call trline(x1,y1,x2,y1,0,1.5)
        end if
      end do
      nnprf1 = nprof
C    ****    plot profiles for second day when this was chosen   ***   V
      if (isite .eq. 4 .or. isite .eq. 5 .or. isite .eq. 6) then
        if (i12frmt .eq. 1) call wrtsymb(0.01,1.03,20,'VIPIR',0,1,1)
      else
        if (i12frmt .eq. 1) call wrtsymb(0.01,1.03,20,'Digisonde',0,1,1)
      end if
      iyear = kyear
      if (kday .eq. 20) then
        if (i12frmt .eq. 3) call plt1cntr
      end if
      if (i12frmt .eq. 2 .or. i12frmt .eq. 4) then
        call fnddoy(kyear,kmonth,kday,idoy)
        idoy = idoy - 1
        if (idoy .ge. 1) then
          call FNDMD(iyear,imonth,iday,idoy)
        else
          iyear = iyear - 1
          imonth = 12
          iday = 31
        end if
        write (unit=cha2a,fmt='(i2.2)') iday
        write (unit=chayear,fmt='(i4)') iyear
        chadate = cham(imonth)//' '//cha2a//', '//chayear
        call wrtsymb(-0.03,1.03,16,chadate,0,1,1)
        call readdigi(iyear,imonth,iday)
        if (i12frmt .eq. 2) t = 0.5
        if (i12frmt .eq. 4) t = 22.0/24.0
        if (i12frmt .eq. 2) tn = 24.0
        if (i12frmt .eq. 4) tn = 6.0
        do j = 1,nprof
          xdnmax = 0.0
          do i = 1,npts(j)
            dens(i) = alog10(freq(j,i))
            altit(i) = alt(j,i)
            if (xdnmax .lt. freq(j,i)) then
              xdnmax = freq(j,i)
              ifpeak = i
            end if
          end do
          xden2(j) = xdnmax
          xtim2(j) = xhr(j)*60.0*60.0 + xmn(j)*60.0 + xsec(j)
          xalt2(j) = alt(j,ifpeak)
          x1 = xhr(j)/24.0 + xmn(j)/60.0/24.0 + xsec(j)/60.0/60.0/24.0
     &      - t
          t1 = xhr(j)*60.0*60.0 + xmn(j)*60.0 + xsec(j)
          t2 = 24.0*60.0*60.0
          if (j.lt.nprof)t2=xhr(j+1)*60.0*60.0+xmn(j+1)*60.0+xsec(j+1)
          tsep = 15.0
          if ((t2-t1) .lt. 310.0) tsep = 5.0
          do i = 2,npts(j)-1
            if (altit(i-1) .gt. 100 .and. altit(i+1) .lt. 1060.0) then
              icol = (dens(i) - 3.0)/3.5*100.0
              if (icol .lt. 1) go to 2
              if (icol .gt. 99) icol = 99
              y0 = (altit(i) - 100.0)/x900
              y1 = y0 - (altit(i) - altit(i-1))/2.0/x900
              y2 = y0 + (altit(i+1) - altit(i))/2.0/x900
              if (y2 .gt. 1.0) y2 = 1.0
              x3 = x1
              if (i12frmt .eq. 4) x3 = x1*4.0
              x4 = x1 + tsep/60.0/tn
              if (i12frmt .eq. 4) x4 = x3 + tsep/60.0/tn
              if (x3 .ge. 0.0) call pixel2(x3,y1,x4,y2,icol)
            end if
2           continue
          end do
        end do
        n2 = nprof
C    ****    plot PEAK altitude of F layer for each profile    ****    V
        do j = 1,nprof
          t1 = xhr(j)*60.0*60.0 + xmn(j)*60.0 + xsec(j)
          t2 = 24.0*60.0*60.0
          if (j.lt.nprof)t2=xhr(j+1)*60.0*60.0+xmn(j+1)*60.0+xsec(j+1)
          tsep = 15.0
          if ((t2-t1) .lt. 310.0) tsep = 5.0
          x1 = xhr(j)/24.0 + xmn(j)/60.0/24.0 + xsec(j)/60.0/60.0/24.0
     &      - t
          x2 = x1 + tsep/60.0/tn
          y1 = (rmxalt(j) - 100.0)/x900
          x3 = x1
          if (i12frmt .eq. 4) x3 = x1*4.0
          x4 = x1 + tsep/60.0/tn
          if (i12frmt .eq. 4) x4 = x3 + tsep/60.0/tn
          if (rmxalt(j) .gt. 100.0 .and. x3 .ge. 0.0) then
            call trline(x3,y1,x4,y1,0,1.333)
          end if
        end do
      end if
      nnprf2 = nprof
      call frmxden
      call nescale
C      call frmjdn
c      if (kday .eq. 20) then
c        call pltjdn(xden1,xden2,xtim1,xtim2,n1,n2)
c        print *,'do scintillation plot'
c        call frmscnt
c        call frmglow
c      end if
      if (ibott .eq. 0 .and. i12frmt .eq. 2) then
        call plotVVel
        call plotTEC(kyear,kmonth,kday)
c        call plotscint(kyear,kmonth,kday)
      end if
c       write END OF SPLOT in output file
      call plotend
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine nescale
      common /cmmsite/  isite,ibott
      dimension z(10)
      idc = 2
      x1 = 462.0
      y1 = 415.0 + 325.0
      if (ibott .eq. 1) then
        x1 = 453.0
        y1 = 257.0
      end if
      do i = 1,89
        y2 = y1 - 1.5*float(i)
        do j = 1,10
          z(j) = float((91-i)/5*5)/90.0
        end do
        call fillx1(x1,y2,z,8,idc)
      end do
      call ttline(x1,y1+1.5,x1+20.0,y1+1.5,0,1.0)
      call symbol(x1+22.0,y1-3.0,16,'3x10',0,1,1)
      call symbol(x1+22.0+34.0,y1-3.0+7.0,11,'6',0,1,1)
      call symbol(x1+58.0,y1-37.0,16,'Log(Ne)',-90,1,1)
      y2 = y1 - 90.0*1.5 + 0.1 + 3.0
      call ttline(x1,y2+2.0,x1+20.0,y2+2.0,0,1.0)
      call symbol(x1+22.0,y2-3.0,16,'10',0,1,1)
      call symbol(x1+22.0+19.0,y2-3.0+7.0,11,'3',0,1,1)
C    ****    ....    ****
      y2 = y1 - 90.0*1.5/3.5*2.5 + 0.1 + 3.0
      call ttline(x1,y2+2.0,x1+20.0,y2+2.0,0,1.0)
      call symbol(x1+22.0,y2-3.0,16,'10',0,1,1)
      call symbol(x1+22.0+19.0,y2-3.0+7.0,11,'4',0,1,1)
      y2 = y1 - 90.0*1.5/3.5*1.5 + 0.1 + 3.0
      call ttline(x1,y2+2.0,x1+20.0,y2+2.0,0,1.0)
      call symbol(x1+22.0,y2-3.0,16,'10',0,1,1)
      call symbol(x1+22.0+19.0,y2-3.0+7.0,11,'5',0,1,1)
      y2 = y1 - 90.0*1.5/3.5*0.5 + 0.1 + 3.0
      call ttline(x1,y2+2.0,x1+20.0,y2+2.0,0,1.0)
      call symbol(x1+22.0,y2-3.0,16,'10',0,1,1)
      call symbol(x1+22.0+19.0,y2-3.0+7.0,11,'6',0,1,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine plotVVel
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      common /cmmsite/  isite,ibott
      dimension    rmxalt(288)
      common /cmmaxalt/ rmxalt
      dimension xden1(288),xden2(576),xtim1(288),xtim2(576),xalt1(288),
     & xalt2(576)
      common /cmmpeaks/ xden1,xden2,xtim1,xtim2,xalt1,xalt2,nnprf1,
     &  nnprf2
      dimension xx(11),yy(11)
      real*8  a,b
      YFR1   = 73.0 + 185.0
      YFR2   = YFR1 + 100.0
      call frameVV
      do i = 4,nnprf1-3
        x1 = xtim1(i)/60.0/60.0/24.0 + 0.5
        x2 = xtim1(i+1)/60.0/60.0/24.0 + 0.5
        ztime = xtim1(i+1) - xtim1(i)
        jj = 0
        do j = 1,7
          if (xalt1(i+j-4) .ne. 0.0) then
            jj = jj + 1
            xx(jj) = xtim1(i+j-4)
            yy(jj) = xalt1(i+j-4)*1000.0
          end if
        end do
        if (x1 .gt. 0.0 .and. x1 .lt. 1.0 .and. jj .ge. 3) then
          if (xalt1(i) .ne. 0.0 .and. xalt1(i+1) .ne. 0.0) then
            call fitlin(xx,yy,jj,a,b)
            vvel  = b
C            print *,i,xtim1(i),xtim1(i+1),ztime,vvel
            y1 = (vvel + 50.0)/50.0/2.0
            if (y1 .lt. 0.0) y1 = 0.0
            if (y1 .gt. 1.0) y1 = 1.0
            if (xtim1(i) .lt. 4.0*3600.0) then
              call trline(x1,y1,x2,y1,0,3.9)
            end if
          end if
        end if
      end do
C    ****    ....    copy first 288 values into first day  ....   ***   V
      do i = 1,288
        xtim2(i+nnprf2) = xtim1(i) + 24.0*60.0*60.0
        xalt2(i+nnprf2) = xalt1(i)
      end do
C    ****    ....    plot prior day, but last 12 hours    ....   ***   V
      do i = 6,nnprf2+4
        x1 = xtim2(i)/60.0/60.0/24.0 - 0.5
        x2 = xtim2(i+1)/60.0/60.0/24.0 - 0.5
        ztime = xtim1(i+1) - xtim1(i)
        jj = 0      
        do j = 1,11
          if (xalt2(i+j-6) .ne. 0.0) then
            jj = jj + 1
            xx(jj) = xtim2(i+j-6)
            yy(jj) = xalt2(i+j-6)*1000.0
          end if
        end do
        if (x1 .gt. 0.0 .and. x1 .lt. 1.0 .and. jj .ge. 3) then
          if (xalt2(i) .ne. 0.0 .and. xalt2(i+1) .ne. 0.0) then
            call fitlin(xx,yy,jj,a,b)
            vvel  = b
C            print *,i,xtim2(i),xtim2(i+1),ztime,vvel
            y1 = (vvel + 50.0)/50.0/2.0
            if (y1 .lt. 0.0) y1 = 0.0
            if (y1 .gt. 1.0) y1 = 1.0
            if (xtim1(i) .gt. 22.0*3600.0) then
              call trline(x1,y1,x2,y1,0,3.9)
            end if
          end if
        end if
      end do
C    ****    print velocity values for SAMI2 model runs(1)    ****    V
      do i = 6,nnprf2+nnprf1-5
        n11 = 11
        if (i .gt. nnprf2) n11 = 7
        ndiv = (n11 + 1)/2
        jj = 0      
        do j = 1,n11
          if (xalt2(i+j-ndiv) .ne. 0.0) then
            jj = jj + 1
            xx(jj) = xtim2(i+j-ndiv)
            yy(jj) = xalt2(i+j-ndiv)*1000.0
          end if
        end do
        if (jj .ge. 3) then
          call fitlin(xx,yy,jj,a,b)
          vvel  = b
          lhour = ifix(xtim2(i)/60.0/60.0)
          lmin  = ifix(xtim2(i)/60.0) - lhour*60
          write (38,fmt='(2i4,f10.3)') lhour,lmin,vvel
        end if
      end do
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine plotTEC(kyear,kmonth,kday)
      character*16 readTECfile
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      dimension clat(3,121),clon(3,121)
      dimension ctec(3,121)
      integer ilatcol(121)
      dimension crray(2,8000)
      common /cmaxtec/ xmxtec
      data readTECfile /'bxxyyzz_0000.dat'/
      YFR1   = 73.0 + 55.0
      YFR2   = YFR1 + 100.0
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      write (readTECfile(2:7),fmt='(3i2.2)') mod(kyear,100),kmonth,kday
      open (63,file=readTECfile,status='UNKNOWN')
      print *,readTECfile
      kfl = 1
      ncnt = 0
      xmxtec = 50.0
      oneday = 24.0*60.0*60.0
1     continue
      read (63,fmt='(7i4)',end=10,err=10) jyear,jmonth,jday,jhour,jminu,
     &  jsec,ltorut
      if (jyear.ne.kyear .or. jmonth.ne.kmonth .or. jday.ne.kday) then
        print *,'wrong TEC file'
        return
      end if
      do i = 1,121
        read (63,fmt='(9f11.4)') clat(1,i),clon(1,i),ctec(1,i),clat(2,i)
     &    ,clon(2,i),ctec(2,i),clat(3,i),clon(3,i),ctec(3,i)
      end do
      ncnt = ncnt + 1
      x1 = (float(jhour)*60.0*60.0 + float(jminu)*60.0 + float(jsec))/
     &  oneday + 0.5
      if (x1 .ge. 0.0 .and. x1 .le. 1.0) then
        jcnt = 0
        do i = 1,121
          if (clat(kfl,i) .ge. -40.0 .and. clat(kfl,i) .le. 10.0) then
            jcnt = jcnt + 1
            ctec2 = ctec(kfl,i)/xmxtec*100.0
            if (ctec2 .le. 50.0) ctec2 = ctec2*40.0/50.0
            if (ctec2 .gt. 50.0) ctec2 = 60.0 + (ctec2-50.0)*40.0/50.0
            ilatcol(jcnt) = ifix(ctec2)
            if (ilatcol(jcnt) .gt. 99) ilatcol(jcnt) = 99
            if (ilatcol(jcnt) .lt.  1) ilatcol(jcnt) = 1
            crray(1,jcnt) = x1
            crray(2,jcnt) = (clat(kfl,i) + 40.0)/50.0
          end if
        end do
        call bun2coline(crray,ilatcol,jcnt)
      end if
      go to 1
10    continue
      close (63)
      print *,'# of TEC records',ncnt
C    ****    ....    plot other day, always a previous day    ...  **  V
      iyear = kyear
      call fnddoy(kyear,kmonth,kday,idoy)
      idoy = idoy - 1
      if (idoy .ge. 1) then
        call FNDMD(iyear,imonth,iday,idoy)
      else
        iyear = iyear - 1
        imonth = 12
        iday = 31
      end if
      write (readTECfile(2:7),fmt='(3i2.2)') mod(iyear,100),imonth,iday
      open (63,file=readTECfile,status='UNKNOWN')
      print *,readTECfile
      ncnt = 0
2     continue
      read (63,fmt='(7i4)',end=20,err=20) jyear,jmonth,jday,jhour,jminu,
     &  jsec,ltorut
      if (jyear.ne.iyear .or. jmonth.ne.imonth .or. jday.ne.iday) then
        print *,'wrong TEC file'
        return
      end if
      do i = 1,121
        read (63,fmt='(9f11.4)') clat(1,i),clon(1,i),ctec(1,i),clat(2,i)
     &    ,clon(2,i),ctec(2,i),clat(3,i),clon(3,i),ctec(3,i)
      end do
      ncnt = ncnt + 1
      x1 = (float(jhour)*60.0*60.0 + float(jminu)*60.0 + float(jsec))/
     &  oneday - 0.5
      if (x1 .ge. 0.0 .and. x1 .le. 1.0) then
        jcnt = 0
        do i = 1,121
          if (clat(kfl,i) .ge. -40.0 .and. clat(kfl,i) .le. 10.0) then
            jcnt = jcnt + 1
            ctec2 = ctec(kfl,i)/xmxtec*100.0
            if (ctec2 .le. 50.0) ctec2 = ctec2*40.0/50.0
            if (ctec2 .gt. 50.0) ctec2 = 60.0 + (ctec2-50.0)*40.0/50.0
            ilatcol(jcnt) = ifix(ctec2)
c            ilatcol(jcnt) = ifix(ctec(kfl,i)/xmxtec*100.0)
            if (ilatcol(jcnt) .gt. 99) ilatcol(jcnt) = 99
            if (ilatcol(jcnt) .lt.  1) ilatcol(jcnt) = 1
            crray(1,jcnt) = x1
            crray(2,jcnt) = (clat(kfl,i) + 40.0)/50.0
          end if
        end do
        call bun2coline(crray,ilatcol,jcnt)
      end if
      go to 2
20    continue
      close (63)
      print *,'# of TEC records',ncnt
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      OUT1PER = 4.5
      OUT3PER = 4.5
      OUT2PER = 1.5
      OUT4PER = 1.5
      TIN4PER = 0.0
      NT1 = 11
      NT2 = 4
      CALL TICK(NT1,1)
      CALL TICK(NT1,3)
      CALL TICK(NT2,2)
      CALL TICK(NT2,4)
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      ilbl= -40
      idlbl0 = 2
      ilbl0 = 12
      CALL PUTLBLsb(XFR1,YFR1-18.0,DX1,NT1+2,1,ilbl0,idlbl0,2,0,14)
      CALL PUTLBL(XFR1-9.0,YFR1-6.0,DY1,NT2+2,2,ilbl,10,3,0,16)
      call symbol(XFR1-37.0,YFR1+2.0,16,'Geog. Latitude',90,1,1)
      call symbol(0.5*(XFR1+XFR2),YFR1-35.0,16,'Universal Time',0,2,1)
      xmaglat = -12.0
      y1 = (xmaglat + 40.0)/50.0
      call twline(0.0,y1,1.0,y1,0,1.0)
      call TECscale
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine TECscale
      character*2 cha2
      integer ilatcol(121)
      common /cmaxtec/ xmxtec
      dimension crray(2,8000)
      jcnt = 81
      do j = 1,15
        x1 = 1.06 + 0.003*float(j)
        do i = 1,jcnt
          crray(1,i) = x1
          crray(2,i) = float(i-1)/80.0
          if (i .le. 41) ilatcol(i) = i
          if (i .gt. 41) ilatcol(i) = 60 + (i-42)
          if (ilatcol(i) .gt. 99) ilatcol(i) = 99
          if (ilatcol(i) .lt.  1) ilatcol(i) = 1
        end do
        call bun2coline(crray,ilatcol,jcnt)
      end do
      x1 = 1.06
      call trline(x1,1.0,x1+0.06,1.0,0,1.0)
      call trline(x1,0.5,x1+0.06,0.5,0,1.0)
      call trline(x1,0.0,x1+0.06,0.0,0,1.0)
      write (unit=cha2,fmt='(i2.2)') ifix(xmxtec)
      call wrtsymb(1.13,0.96,14,cha2,0,1,1)
      call wrtsymb(1.13,-0.04,14,'0',0,1,1)
      write (unit=cha2,fmt='(i2.2)') ifix(xmxtec/2.0)
      call wrtsymb(1.13,0.46,14,cha2,0,1,1)
      call symbol(510.0,215.0,16,'TEC(units)',-90,1,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE frmxden
      COMMON /CM0001/ NPAGES,NPLOTS,NPLOTP
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      common /com0003/ mplots
      common /cmm12frm/ i12frmt
      DATA XLENG,YLENG /612.,792./
      common /cmmsite/  isite,ibott
      NPLOTS = NPLOTS + 1
      OUT1PER = 1.5
      OUT3PER = 1.5
      OUT2PER = 2.0
      OUT4PER = 2.0
      TIN1PER = 0.0
      TIN2PER = 0.0
      TIN3PER = 0.0
      TIN4PER = 3.0
      YFR1   = 60.0 + 325.0
      YFR2   = YFR1 + 360.0*(1.0 - 4./9.*float(ibott))
      XFR1   = 90.0
      XFR2   = XFR1 + 350.0
C        DRAW THE BOX
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      NT1 = 11
      if (i12frmt .eq. 3) NT1 = 7
      if (i12frmt .eq. 4) NT1 = 5
      NT2 = 8 - 4*ibott
      ilbl = 100
      CALL TICK(NT1,1)
      CALL TICK(NT1,3)
      CALL TICK(NT2,2)
      CALL TICK(NT2,4)
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      ilbl0 = 0
      idlbl0 = 2
      if (i12frmt .eq. 2) ilbl0 = 12
      if (i12frmt .eq. 3) ilbl0 = 16
      if (i12frmt .eq. 3) idlbl0 = 1
      if (i12frmt .eq. 4) ilbl0 = 22
      if (i12frmt .eq. 4) idlbl0 = 1
      CALL PUTLBLsb(XFR1,YFR1-18.0,DX1,NT1+2,1,ilbl0,idlbl0,2,0,14)
      CALL PUTLBL(XFR1-9.0,YFR1-6.0,DY1,NT2+2,2,ilbl,100,3,0,16)
      call symbol(0.5*(XFR1+XFR2),YFR1-35.0,16,'Universal Time',0,2,1)
      call symbol(XFR1-42.0,YFR1+156.0-92.0*float(ibott),16,
     &  'Altitude (km)',90,1,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE frmjdn
      COMMON /CM0001/ NPAGES,NPLOTS,NPLOTP
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      common /com0003/ mplots
      common /cmm12frm/ i12frmt
      DATA XLENG,YLENG /612.,792./
      common /cmmsite/  isite,ibott
C      print *,'frmjdn: isite ',isite
      OUT1PER = 2.5
      OUT3PER = 2.5
      OUT2PER = 1.0
      OUT4PER = 1.0
      TIN1PER = 0.0
      TIN2PER = 1.0
      TIN3PER = 0.0
      TIN4PER = 1.0
      YFR1   = 587.0
      if (ibott .eq. 1) YFR1 = 307.0
      YFR2   = YFR1 + 115.0
      XFR1   = 90.0
      XFR2   = XFR1 + 350.0
C        DRAW THE BOX
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      NT1 = 11
      if (i12frmt .eq. 3) NT1 = 7
      if (i12frmt .eq. 4) NT1 = 5
      NT2 = 5
      if (isite .eq. 2 .or. isite .eq. 3) NT2 = 3
      ilbl = 0
      CALL TICK(NT1,1)
      CALL TICK(NT1,3)
c      CALL TICK(NT2,2)
c      CALL TICK(NT2,4)
      do i = 1,NT2
        y1 = 1.0/float(NT2+1)*float(i)
        call tcline(0.0,y1,1.0,y1,1,1.0)
      end do
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      ilbl0 = 0
      idlbl0 = 2
      if (i12frmt .eq. 2) ilbl0 = 12
      if (i12frmt .eq. 3) ilbl0 = 16
      if (i12frmt .eq. 3) idlbl0 = 1
      if (i12frmt .eq. 4) ilbl0 = 22
      if (i12frmt .eq. 4) idlbl0 = 1
      CALL PUTLBLsb(XFR1,YFR1-15.0,DX1,NT1+2,1,ilbl0,idlbl0,2,0,15)
      CALL PUTLBL(XFR1-6.0,YFR1-6.0,DY1,NT2+2,2,ilbl,5,3,0,16)
c      call symbol(0.5*(XFR1+XFR2),YFR1-37.0,20,'Universal Time',0,2,1)
      call symbol(XFR1-40.0,YFR1+4.0,16,'Density (10**5)',90,1,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine frameVV
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      common /cmm12frm/ i12frmt
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      OUT1PER = 4.5
      OUT3PER = 4.5
      NT1 = 11
      NT2 = 3
      CALL TICK(NT1,1)
      CALL TICK(NT1,3)
      do i = 1,NT2
        y1 = 1.0/float(NT2+1)*float(i)
        call tcline(0.0,y1,1.0,y1,1,1.0)
      end do
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      ilbl= -50
      idlbl0 = 2
      ilbl0 = 12
      CALL PUTLBLsb(XFR1,YFR1-18.0,DX1,NT1+2,1,ilbl0,idlbl0,2,0,14)
      CALL PUTLBL(XFR1-9.0,YFR1-6.0,DY1,NT2+2,2,ilbl,25,3,0,16)
      call symbol(XFR1-37.0,YFR1-15.0,16,'Vertical Drift (m/s)',90,1,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine pltjdn(xden1,xden2,xtim1,xtim2,n1,n2)
      dimension xden1(288),xden2(288),xtim1(288),xtim2(288)
      common /cmm12frm/ i12frmt
      common /cmmsite/  isite,ibott
      character*18 chadate
      common /commdat/ chadate
      t = 0.0
      if (i12frmt .eq. 2) t = 0.5
      if (i12frmt .eq. 3) t = -2.0
      if (i12frmt .eq. 4) t = 0.333
      x24 = 24.0
      if (i12frmt .eq. 3) x24 = 8.0
      if (i12frmt .eq. 4) x24 = 6.0
      nprof = n1
      do j = 1,nprof
        t1 = xtim1(j)
        t2 = 24.0*60.0*60.0
        if (j .lt. nprof) t2 = xtim1(j+1)
        tsep = 15.0
        if ((t2-t1) .lt. 310.0) tsep = 5.0
C         ***  time m= 5.0 (may 15)
        tsep = 5.0
        x1 = xtim1(j)/60.0/60.0/x24 + t
        x2 = x1 + tsep/60.0/x24
        y1 = xden1(j)/3000000.0
        if (j .ne. nprof) y2 = xden1(j+1)/2000000.0
        if (j .eq. nprof) y2 = xden1(j)/2000000.0
        if (isite .eq. 2 .or. isite .eq. 3) y1 = xden1(j)/2000000.0
        if (xden1(j) .gt. 0.0 .and. x1 .lt. 1.0 .and. x1 .gt. 0.0) then
          if (t1 .lt. t2 .or. j .eq. nprof) then
            print *,j,t1,t2
            if (j .gt. 180) then
            call trline(x1,y1,x2,y2,0,1.5)
            end if
          end if
        end if
      end do
      if (i12frmt .eq. 2) then
        nprof = n2
        do j = 1,nprof
          t1 = xtim2(j)
          t2 = 24.0*60.0*60.0
          if (j .lt. nprof) t2 = xtim2(j+1)
          tsep = 15.0
          if ((t2-t1) .lt. 310.0) tsep = 5.0
          x1 = xtim2(j)/60.0/60.0/24.0 - 0.5
          x2 = x1 + tsep/60.0/24.0
          y1 = xden2(j)/3000000.0
          if (isite .gt. 1) y1 = xden2(j)/2000000.0
          if (xden2(j) .gt. 0.0 .and. x1 .ge. 0.0) then
            call trline(x1,y1,x2,y1,0,1.333)
          end if
        end do
      end if
      call wrtsymb(0.99,1.03,16,chadate,0,3,1)
      if (i12frmt .eq. 3) then
        if (isite.eq.1) call wrtsymb(0.01,1.04,16,'Jicamarca Digisonde',
     &    0,1,1)
        if (isite.eq.2) call wrtsymb(0.01,1.04,16,'Qaanaaq Digisonde',0,
     &    1,1)
        if (isite.eq.3) call wrtsymb(0.01,1.04,16,'Sonde Digisonde',0,1,
     &    1)
        if (isite.eq.4) call wrtsymb(0.01,1.04,16,'Jicamarca VIPIR',
     &    0,1,1)
        if (isite.eq.5) call wrtsymb(0.01,1.04,16,'Tucuman VIPIR',0,1,1)
        if (isite.eq.6) call wrtsymb(0.01,1.04,16,'Tupiza VIPIR',0,1,1)
      end if
      if (i12frmt .eq. 4) then
        if (isite.eq.1) call wrtsymb(0.01,1.04,16,'Jicamarca Digisonde',
     &    0,1,1)
        if (isite.eq.2) call wrtsymb(0.01,1.04,16,'Qaanaaq Digisonde',0,
     &    1,1)
        if (isite.eq.3) call wrtsymb(0.01,1.04,16,'Sonde Digisonde',0,1,
     &    1)
        if (isite.eq.4) call wrtsymb(0.01,1.04,16,'Jicamarca VIPIR',
     &    0,1,1)
        if (isite.eq.5) call wrtsymb(0.01,1.04,16,'Tucuman VIPIR',0,1,1)
        if (isite.eq.6) call wrtsymb(0.01,1.04,16,'Tupiza VIPIR',0,1,1)
      end if
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE frmscnt
      COMMON /CM0001/ NPAGES,NPLOTS,NPLOTP
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      common /com0003/ mplots
      common /cmm12frm/ i12frmt
      DATA XLENG,YLENG /612.,792./
      common /cmmsite/  isite,ibott
      integer isc(24,12),ihr(24)
      OUT1PER = 2.5
      OUT3PER = 2.5
      OUT2PER = 0.0
      OUT4PER = 0.0
      TIN1PER = 0.0
      TIN2PER = 2.0
      TIN3PER = 0.0
      TIN4PER = 2.0
      YFR1   = 459.0
      YFR2   = YFR1 + 115.0
      XFR1   = 90.0
      XFR2   = XFR1 + 350.0
C        DRAW THE BOX
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      NT1 = 11
      if (i12frmt .eq. 3) NT1 = 7
      if (i12frmt .eq. 4) NT1 = 5
      NT2 = 5
      ilbl = 0
      CALL TICK(NT1,1)
      CALL TICK(NT1,3)
      CALL TICK(NT2,2)
      CALL TICK(NT2,4)
      do i = 1,NT2
        y1 = 1.0/float(NT2+1)*float(i)
c        call tcline(0.0,y1,1.0,y1,1,1.0)
      end do
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      ilbl0 = 0
      idlbl0 = 2
      if (i12frmt .eq. 2) ilbl0 = 12
      if (i12frmt .eq. 3) ilbl0 = 16
      if (i12frmt .eq. 3) idlbl0 = 1
      if (i12frmt .eq. 4) ilbl0 = 22
      if (i12frmt .eq. 4) idlbl0 = 1
      CALL PUTLBLsb(XFR1,YFR1-15.0,DX1,NT1+2,1,ilbl0,idlbl0,2,0,15)
c      CALL PUTLBL(XFR1-8.0,YFR1-6.0,DY1,NT2+2,2,ilbl,5,3,0,17)
c      call symbol(0.5*(XFR1+XFR2),YFR1-37.0,20,'Universal Time',0,2,1)
      call symbol(XFR1-6.0,YFR1-5.0,16,'0.0',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+DY1,16,'0.2',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+2.0*DY1,16,'0.4',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+3.0*DY1,16,'0.6',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+4.0*DY1,16,'0.8',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+5.0*DY1,16,'1.0',0,3,1)
      call symbol(XFR1-6.0,YFR2-5.0,16,'1.2',0,3,1)
      call symbol(XFR1-40.0,YFR1+28.0,16,'S4 - index',90,1,1)
      open (61,file='th20nov03.dat',status='UNKNOWN')
      do i = 1,24
        read (61,1) iyr,imn,idy,ihr(i),(isc(i,j),j=1,12)
c        print *,isc
1       format (4i2,2x,12i4)
      end do
      do i = 1,24
        do j = 2,11
          if (isc(i,j) .lt. 0) isc(i,j) = (isc(i,j-1) + isc(i,j+1))/2
        end do
      end do
      iflag = 0
      do i = 1,24
        do j = 1,12
          xh = float(ihr(i)) + float(j-1)*5.0/60.0 - 16.0
          if (xh .ge. 0.0) then
            if (isc(i,j) .lt. 0) iflag = 0
            y2 = float(isc(i,j))/120.0
            if (y2 .gt. 1.0) y2 = 1.0
            x2 = xh/8.0
            if (iflag .eq. 1) call tcline(x1,y1,x2,y2,99,1.2)
            x1 = x2
            y1 = y2
            if (isc(i,j) .gt. 0) iflag = 1
          end if
        end do
      end do
      close (61)
      call wrtsymb(1.03,0.94,16,'Thule 5-min S4',-90,1,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine frmglow
      COMMON /CM0001/ NPAGES,NPLOTS,NPLOTP
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      common /com0003/ mplots
      common /cmm12frm/ i12frmt
      dimension    jtime(200),stdv1(200),stdv2(200),ktime(200)
      OUT1PER = 2.5
      OUT3PER = 2.5
      OUT2PER = 0.0
      OUT4PER = 0.0
      TIN1PER = 0.0
      TIN2PER = 2.0
      TIN3PER = 0.0
      TIN4PER = 2.0
      YFR1   = 601.0
      YFR2   = YFR1 + 115.0
      XFR1   = 90.0
      XFR2   = XFR1 + 350.0
C        DRAW THE BOX
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      NT1 = 11
      if (i12frmt .eq. 3) NT1 = 7
      if (i12frmt .eq. 4) NT1 = 5
      NT2 = 3
      ilbl = 0
      CALL TICK(NT1,1)
      CALL TICK(NT1,3)
      CALL TICK(NT2,2)
      CALL TICK(NT2,4)
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      ilbl0 = 0
      idlbl0 = 2
      if (i12frmt .eq. 2) ilbl0 = 12
      if (i12frmt .eq. 3) ilbl0 = 16
      if (i12frmt .eq. 3) idlbl0 = 1
      if (i12frmt .eq. 4) ilbl0 = 22
      if (i12frmt .eq. 4) idlbl0 = 1
      CALL PUTLBLsb(XFR1,YFR1-15.0,DX1,NT1+2,1,ilbl0,idlbl0,2,0,15)
      call symbol(XFR1-6.0,YFR1-5.0,16,'-160',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+DY1,16,'-80',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+2.0*DY1,16,'0',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+3.0*DY1,16,'80',0,3,1)
      call symbol(XFR1-6.0,YFR1-5.0+4.0*DY1,16,'160',0,3,1)
      call symbol(XFR1-40.0,YFR1+12.0,16,'6300-Airglow',90,1,1)
      open (62,file='airglow.dat',status='UNKNOWN')
1     continue
      read (62,fmt='(i5,1x,2i8,2f10.3,2i8)',end=2,err=2) ir,idate,itime,
     &  airg1,airg2,jairg1,jairg2
      jtime(ir) = itime
      stdv1(ir) = airg1
      stdv2(ir) = airg2
      go to 1
2     continue
      close (62)
      ncnt = ir
      do i = 1,ncnt
        ktime(i) = (jtime(i)/10000)*60 + mod(jtime(i),10000)/100
      end do
      do i = 1,ncnt-1
        y1 = (stdv1(i) + 2.0)/4.0
        if (y1 .gt. 1.0) y1 = 1.0
        y2 = (stdv1(i+1) + 2.0)/4.0
        if (y2 .gt. 1.0) y2 = 1.0
        x1 = (float(ktime(i))/60.0-16.0)/8.0
        x2 = (float(ktime(i+1))/60.0-16.0)/8.0
        call tcline(x1,y1,x2,y2,1,1.0)
      end do
      call wrtsymb(1.03,0.85,16,'6300-airglow',-90,1,1)
      y1 = 2.5/4.0
      call trline(0.025,y1,0.975,y1,4,1.2)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine fnddoy(iyear,imon,iday,idoy)
      DIMENSION MO(12),MObis(12)
      DATA	MO/0,31,59,90,120,151,181,212,243,273,304,334/
      DATA	MObis/0,31,60,91,121,152,182,213,244,274,305,335/
      idoy = iday + MO(imon)
      if (mod(iyear,4) .eq. 0) idoy = iday + MObis(imon)
      print *,'idoy: ',idoy
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE FNDMD(kyear,month,iday,IDOY)
      DIMENSION MO(12),MObis(12)
      DATA	MO/0,31,59,90,120,151,181,212,243,273,304,334/
      DATA	MObis/0,31,60,91,121,152,182,213,244,274,305,335/
      i4    = mod(kyear,4)
      IMO    = 0
      MOBE   = 0
5     IMO    = IMO + 1
      MOOLD  = MOBE
      IF (IMO .GT. 12) GO TO 55
      if (i4 .ne. 0) MOBE   = MO(IMO)
      if (i4 .eq. 0) MOBE   = MObis(IMO)
      IF(MOBE .LT. IDOY) GO TO 5
55    MONTH  = IMO - 1
      IDAY   = IDOY - MOOLD
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE MAKPLT(XX,YY,J)
      DIMENSION XX(33000),YY(33000)
      DIMENSION ARRAY(2,5000)
      save
      DO 2 II = 1,J,200
        i1 = II
        i2 = II + 199
        if (i2 .gt. J) i2 = J
        l = 0
        do 1 i = i1,i2
          l = l + 1
          ARRAY(1,l) = XX(i)
          ARRAY(2,l) = YY(i)
1       continue
        J1 = i2 - i1 + 1
        CALL bunblin(ARRAY,J1)
2     CONTINUE
      return
      END
c--------1---------2---------3---------4---------5---------6---------7--
      SUBROUTINE bunblin(array,N)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      DIMENSION     array(2,5000)
      CHARACTER*1  BRAK1,BRAK2
      DATA BRAK1,BRAK2 /'[',']'/
      SAVE
      DO I = 1,N
         array(1,I) = array(1,I)*(XFR2 - XFR1) + XFR1
         array(2,I) = array(2,I)*(YFR2 - YFR1) + YFR1
      END DO
1     format (1x,i3)
      NI = 9
      IF (N .LT. 9) NI = N
      WRITE (LF,2) BRAK1,(array(1,I),I=1,NI)
2     FORMAT (1X,A1,1X,9F6.1)
      IF (N .GT. 9) THEN
        DO 4 J = 10,N,9
          N1   = J
          N2   = J + 8
          IF (N2 .GT. N) N2 = N
          WRITE (LF,3) (array(1,I),I=N1,N2)
3         FORMAT (3X,9F6.1)
4       CONTINUE
      END IF
      WRITE (LF,2) BRAK2
      WRITE (LF,2) BRAK1,(array(2,I),I=1,NI)
      IF (N .GT. 9) THEN
        DO 5 J = 10,N,9
          N1   = J
          N2   = J + 8
          IF (N2 .GT. N) N2 = N
          WRITE (LF,3) (array(2,I),I=N1,N2)
5       CONTINUE
      END IF
      WRITE (LF,2) BRAK2
      WRITE (LF,6)
6     FORMAT (2X,'bline')
      return
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE XSYMBOL(X1,Y1,ISIZE,CHA,JANGLE,ILOCPAR,IFONT)
C        types a float number
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      CHARACTER*(*)   CHA
      IANGLE = JANGLE + 90
c      IF (X1 .LT. 0.0 .OR. X1 .GT. 1.0) return
c      IF (Y1 .LT. 0.0 .OR. Y1 .GT. 1.0) return
      X = (1.0 - Y1)*(XFR2- XFR1) + XFR1
      Y = X1*(YFR2- YFR1) + YFR1
      WRITE (LF,1) CHA,ILOCPAR,X,Y,IANGLE,IFONT,ISIZE
1     FORMAT (2X,'(',A,')',I3,2F9.2,I6,I3,I4,2X,'typefsym')
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE EELINE(X1,Y1)
      COMMON /NUMBPT/ NP
      COMMON /EARRAY/ ARRAY(2,3000)
      IF (NP .GT. 3000) return
      IF (X1 .GT. 1.0 .OR. X1 .LT. 0.0) return
      NP = NP + 1
      ARRAY(1,NP) = x1
      ARRAY(2,NP) = Y1
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE DUMPEE(ARRAY,N,ICOL,WIDTH)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      DIMENSION ARRAY(2,3000)
      CHARACTER*1  BRAK1,BRAK2
      DATA BRAK1,BRAK2 /'[',']'/
      NN   = MIN(N,3000)
      DO 10 I = 1,NN
         ARRAY(1,I) = ARRAY(1,I)*(XFR2 - XFR1) + XFR1
         ARRAY(2,I) = ARRAY(2,I)*(YFR2 - YFR1) + YFR1
10    CONTINUE
      DO 6 L = 1,NN,50
        L1 = L
        L2 = L + 50
        IF (L2 .GT. NN) L2 = NN
        LD = L2 - L1
        IF (ICOL .EQ. 0) WRITE (LF,1) WIDTH
        IF (ICOL .NE. 0) WRITE (LF,1) WIDTH,ICOL
1       FORMAT (2X,F8.2,I5)
        NI  = 11
        IF (LD .LT. 11) NI = LD
        DO 5 K = 1,2
          WRITE (LF,2) BRAK1,(ARRAY(K,I),I=L1,L1+NI)
2         FORMAT (2X,A1,12F8.2)
          IF (NN .GT. 12) THEN
            DO 4 J = L1+12,L2,12
              N1   = J
              N2   = J + 11
              IF (N2 .GT. L2) N2 = L2
              WRITE (LF,3) (ARRAY(K,I),I=N1,N2)
3             FORMAT (3X,12F8.2)
4           CONTINUE
          END IF
          WRITE (LF,2) BRAK2
5       CONTINUE
        IF (ICOL .EQ. 0) WRITE (LF,*) '  xyplot '
        IF (ICOL .NE. 0) WRITE (LF,*) '  xycolor '
6     CONTINUE
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE PUTCDOT(X1,Y1,ICOL)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      if (y1 .lt. 0.0 .or. y1 .gt. 1.0) return
      if (ICOL .lt. 1) ICOL = 1
      if (ICOL .gt. 99) ICOL = 99
      X = X1*(XFR2 - XFR1) + XFR1
      Y = Y1*(YFR2 - YFR1) + YFR1
      jcol = 52
      WRITE (LF,1) X,Y,ICOL,jcol
1     FORMAT (2X,2F10.3,2I5,2X,'drwcol')
      return
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE PUTCOLD(X1,Y1,ICOL,JCOL)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      if (y1 .lt. 0.0 .or. y1 .gt. 1.25) return
      if (ICOL .lt. 1) ICOL = 1
      if (ICOL .gt. 99) ICOL = 99
      X = X1*(XFR2 - XFR1) + XFR1
      Y = Y1*(YFR2 - YFR1) + YFR1
      WRITE (LF,1) X,Y,ICOL,jcol
1     FORMAT (2X,2F10.3,2I5,2X,'drwcol')
c1     FORMAT (2X,2F10.3,2I5,2X,'drwfszcol')
      return
      END
C--------1---------2---------3---------4---------5---------6---------7-V
C          CALL PUTBDOT(XU,YU,ICOL)
      SUBROUTINE PUTBDOT(X1,Y1,ICOL)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      X = X1*(XFR2 - XFR1) + XFR1
      Y = Y1*(YFR2 - YFR1) + YFR1
      jcol = 0
      WRITE (LF,1) X,Y,ICOL,jcol
1     FORMAT (2X,2F10.3,2I5,2X,'drwbdbw')
      return
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE MAKSYMB(XX,YY,J,jd)
      DIMENSION XX(100000),YY(100000)
      DIMENSION ARRAY(2,200)
      save
      if (J .eq. 0) return
      id = mod(jd,10)
      DO 2 II = 1,J,200
        i1 = II
        i2 = II + 199
        if (i2 .gt. J) i2 = J
        l = 0
        do 1 i = i1,i2
          l = l + 1
          ARRAY(1,l) = XX(i)
          ARRAY(2,l) = YY(i)
1       continue
        J1 = i2 - i1 + 1
        CALL onlydot(ARRAY,J1,id)
2     CONTINUE
      return
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE onlydot(array,N,id)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      DIMENSION     array(2,200)
      CHARACTER*1  BRAK1,BRAK2
      DATA BRAK1,BRAK2 /'[',']'/
      SAVE
      DO 10 I = 1,N
         array(1,I) = array(1,I)*(XFR2 - XFR1) + XFR1
         array(2,I) = array(2,I)*(YFR2 - YFR1) + YFR1
10    CONTINUE
      NI = 12
      IF (N .LT. 12) NI = N
      WRITE (LF,2) BRAK1,(array(1,I),I=1,NI)
2     FORMAT (2X,A1,12F6.1)
      IF (N .GT. 12) THEN
        DO 4 J = 13,N,12
          N1   = J
          N2   = J + 11
          IF (N2 .GT. N) N2 = N
          WRITE (LF,3) (array(1,I),I=N1,N2)
3         FORMAT (3X,12F6.1)
4       CONTINUE
      END IF
      WRITE (LF,2) BRAK2
      WRITE (LF,2) BRAK1,(array(2,I),I=1,NI)
      IF (N .GT. 12) THEN
        DO 5 J = 13,N,12
          N1   = J
          N2   = J + 11
          IF (N2 .GT. N) N2 = N
          WRITE (LF,3) (array(2,I),I=N1,N2)
5       CONTINUE
      END IF
      WRITE (LF,2) BRAK2
      if (id .eq. 1) WRITE (LF,6)
      if (id .eq. 2) WRITE (LF,7)
      if (id .eq. 3) WRITE (LF,8)
      if (id .eq. 4) WRITE (LF,9)
6     FORMAT (2X,'onlydot')
7     FORMAT (2X,'onlylin')
8     FORMAT (2X,'dotplt')
9     FORMAT (2X,'onlyedot')
      return
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine pixel2(X1,Y1,X2,Y2,icol)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      IF (X1 .LT. 0.0 .or. X1 .gt. 1.08) return
      IF (Y1 .LT. 0.0 .OR. Y1 .GT. 1.0) return
      X = X1*(XFR2- XFR1) + XFR1
      Y = Y1*(YFR2- YFR1) + YFR1
      a = X2*(XFR2- XFR1) + XFR1
      b = Y2*(YFR2- YFR1) + YFR1
      WRITE (LF,1) X,Y,a,b,ICOL
1     FORMAT (1X,4F7.2,I3,' colp2')
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine pltmeprf(kyear,kmonth,kday)
      character*2  cha2a
      character*4  chayear
      character*9  cham(12)
      character*18 chadate
      common /commdat/ chadate
      dimension    alt(288,999),freq(288,999),npts(288),xhr(288),
     &  xmn(288),xsec(288)
      common   /c22data/ alt,freq,npts,nprof,xhr,xmn,xsec
      dimension    rmxalt(288)
      common /cmmaxalt/ rmxalt
      dimension dens(999),altit(999)
      common /cmm12frm/ i12frmt
      dimension xden1(288),xden2(288),xtim1(288),xtim2(288)
      common /cmmsite/  isite,ibott
      data      cham /'  January',' February','    March','    April',
     &    '      May','     June','     July','   August','September',
     &    '  October',' November',' December'/
      CALL INITIALIZE(1)
      call frameprf
      x900 = 400.0
      xhour = 20.0
      do k = 1,7
        xmin = float(k+1)*5.0
        icol = (98.0/6.0)*float(k-1) + 1
        if (icol .gt. 99) icol = 99
        do j = 1,nprof
          xdnmax = 0.0
          if (npts(j) .eq. 0) go to 3
          do i = 1,npts(j)
            dens(i) = alog10(freq(j,i))
            altit(i) = alt(j,i)
            if (xdnmax .lt. freq(j,i)) then
              xdnmax = freq(j,i)
              ifpeak = i
            end if
          end do
          if (xhr(j) .ne. xhour .or.  xmn(j) .ne. xmin) go to 3
          print *,xhr(j),xmn(j)
          iend = ifpeak - 1
          do i = 2,iend
            if (altit(i-1) .gt. 200.0 .and. altit(i) .lt. 1060.0) then
              x0 = (dens(i-1) - 2.0)/5.0
              y0 = (altit(i-1) - 100.0)/x900
              x1 = (dens(i) - 2.0)/5.0
              y1 = (altit(i) - 100.0)/x900
              call tcline(x0,y0,x1,y1,icol,1.2)
            end if
          end do
3         continue
        end do
      end do
      call plotend
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine frameprf
      COMMON /CM0001/ NPAGES,NPLOTS,NPLOTP
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      common /com0003/ mplots
      common /cmm12frm/ i12frmt
      DATA XLENG,YLENG /612.,792./
      NPLOTS = NPLOTS + 1
      OUT1PER = 1.5
      OUT3PER = 1.5
      OUT2PER = 2.0
      OUT4PER = 2.0
      TIN1PER = 0.0
      TIN2PER = 0.0
      TIN3PER = 0.0
      TIN4PER = 3.0
      YFR1   = 90.0
      YFR2   = YFR1 + 400.0
      XFR1   = 90.0
      XFR2   = XFR1 + 350.0
C        DRAW THE BOX
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      NT1 = 4
      NT2 = 3
      ilbl = 100
      CALL TICK(NT1,1)
      CALL TICK(NT1,3)
      CALL TICK(NT2,2)
      CALL TICK(NT2,4)
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      ilbl0 = 2
      idlbl0 = 1
      CALL PUTLBLsb(XFR1,YFR1-18.0,DX1,NT1+2,1,ilbl0,idlbl0,2,0,16)
      CALL PUTLBL(XFR1-9.0,YFR1-6.0,DY1,NT2+2,2,ilbl,100,3,0,16)
      call symbol(XFR1-42.0,YFR1+156.0,16,'Altitude (km)',90,1,1)
      call symbol(0.5*(XFR1+XFR2),YFR1-39.0,16,'Log(Density)',0,2,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine plt1cntr
      dimension    alt(288,999),freq(288,999),npts(288),xhr(288),
     &  xmn(288),xsec(288)
      common   /c22data/ alt,freq,npts,nprof,xhr,xmn,xsec
      dimension    h(288,90),d(288,90)
      dimension p1(600),p2(600),yy1(600),yy2(600)
      COMMON /NUMBPT/ NNPP
      COMMON /XARRAY/ ARRAY(4,9000)
      dimension    alt2(288,999),freq2(288,999),npts2(288),xhr2(288),
     &  xmn2(288),xsec2(288)
      do i = 1,288
        do j = 1,90
          h(i,j) = 0.0
          d(i,j) = 0.0
        end do
      end do
c        ***   sets according to time
      print *,'plot contours '
      nprof2 = 0
      xprevt = 15.99
10    continue
      t0diff = 90000.0
      do j = 1,nprof
        if (npts(j) .gt. 0) then
          xtime = xhr(j) + xmn(j)/60.0 + xsec(j)/60.0/60.0
          if (xtime .gt. xprevt) then
            tdiff = xtime - xprevt
            if (tdiff .lt. t0diff) then
              t0diff = tdiff
              j1     = j
            end if
          end if
        end if
      end do
      if (t0diff .lt. 90000.0) then
        nprof2 = nprof2 + 1
        npts2(nprof2) = npts(j1)
        xhr2(nprof2)  = xhr(j1)
        xmn2(nprof2)  = xmn(j1)
        xsec2(nprof2) = xsec(j1)
        xprevt = xhr(j1) + xmn(j1)/60.0 + xsec(j1)/60.0/60.0
c        print *,nprof2,xhr2(nprof2),xmn2(nprof2),xsec2(nprof2),j1
        npt = npts(j1)
        do i = 1,npt
          alt2(nprof2,i) = alt(j1,i)
          freq2(nprof2,i) = freq(j1,i)
        end do
        do i = 1,51
          hh = float(i-1)*10.0 + 100.0
          call getdens(j1,hh,dens)
          h(nprof2,i) = hh
          d(nprof2,i) = dens
        end do
c        print *,(d(nprof2,i),i=1,51)
        go to 10
      end if
c        ***   makes plot (vs. density)
      nn   = 51
      do i = 1,nn
        yy1(i) = float(i-1)*10.0/500.0
        yy2(i) = float(i-1)*10.0/500.0
      end do
1     continue
      do kk = 1,2
        if (kk .eq. 1) clevel = 0.5
        if (kk .eq. 2) clevel = 3.0
        if (kk .eq. 3) clevel = 20.0
        NNPP   = 0
        iflag1 = 0
        do i = 1,nprof2
          xx2 = (xhr2(i) + xmn2(i)/60.0 + xsec2(i)/60.0/60.0 - 16.0)/8.0
          time2  = xhr2(i)*60.0 + xmn2(i)
c          print *,kk,xx2,time2
          do ii = 1,nn
            p2(ii) = d(i,ii)/10.0**5
          end do
c          find maximum
          dmax = 0.0
          do ii = 1,nn
            if (d(i,ii) .gt. dmax) then
              dmax = d(i,ii)
              imax = ii
            end if
          end do
          if (iflag1 .eq. 1) then
            if (time2-time1 .lt. 6.0) then
              call prfcntr(p1,p2,xx1,xx2,yy1,yy2,clevel,imax)
            end if
          end if
          do ii = 1,nn
            p1(ii) = p2(ii)
          end do
          xx1    = xx2
          time1  = time2
          iflag1 = 1
        end do
        print *,'NNPP: ',NNPP
        width = 1.2
        CALL DUMPCL(ARRAY,NNPP,0,width)
      end do
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine getdens(ii,h,dens)
      dimension    alt(288,999),freq(288,999),npts(288),xhr(288),
     &  xmn(288),xsec(288)
      common   /c22data/ alt,freq,npts,nprof,xhr,xmn,xsec
      dens = 0.0
      hmin = 1000.0
      hmax = 0.0
      npt  = npts(ii)
      do j = 1,npt
        if (alt(ii,j) .lt. hmin) imin = j
        if (alt(ii,j) .lt. hmin) hmin = alt(ii,j)
        if (alt(ii,j) .gt. hmax) hmax = alt(ii,j)
      end do
      if (h .gt. hmax) return
      if (h .le. hmin) return
      diffmn = 1000.0
      do j = 1,npt
        diff = abs(alt(ii,j) - h)
        if (alt(ii,j) .le. h .and. diff .lt. diffmn) then
          diffmn = diff
          dlow   = freq(ii,j)
          hlow   = alt(ii,j)
        end if
      end do
      diffmn = 1000.0
      do j = 1,npt
        diff = abs(alt(ii,j) - h)
        if (alt(ii,j) .gt. h .and. diff .lt. diffmn) then
          diffmn = diff
          dhigh  = freq(ii,j)
          hhigh  = alt(ii,j)
        end if
      end do
      dens = dlow + (dhigh - dlow)/(hhigh - hlow)*(h - hlow)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine prfcntr(R1,R2,THETA1,THETA2,ZZ1,ZZ2,CLEVEL,nn)
      DIMENSION R2(600),R1(600),ZZ1(600),ZZ2(600)
      DIMENSION X(2),Y(2),IDELT(6),DVAL(5)
      DATA IDELT /0,-1,-1,0,0,-1/
      yMAX   = R1(1)
      yMIN   = R1(1)
      DO 1000 I = 1,nn
        IF (R1(I) .LT. yMIN) yMIN = R1(I)
        IF (R1(I) .GT. yMAX) yMAX = R1(I)
        IF (R2(I) .LT. yMIN) yMIN = R2(I)
        IF (R2(I) .GT. yMAX) yMAX = R2(I)
1000  CONTINUE
      XL = 0.0
      YL = 0.0
1010  CTR = CLEVEL
      IF (CTR .LT. yMIN) GO TO 100
      IF (CTR .GT. yMAX) GO TO 100
      NPT = 0
      DO 130 I = 2,nn
        NPT = 0
        DVAL(1) = R2(I-1) - CTR
        DVAL(2) = R1(I-1) - CTR
        DVAL(3) = R1(I) - CTR
        DVAL(4) = R2(I) - CTR
        DVAL(5) = DVAL(1)
        DO 120 ICORN = 1,4
          IF (DVAL(ICORN)) 30,40,40
30        IF (DVAL(ICORN+1)) 120,50,50
40        IF (DVAL(ICORN+1)) 50,50,120
50        NPT = NPT + 1
          DELTA = DVAL(ICORN)/(DVAL(ICORN) - DVAL(ICORN+1))
          X(NPT) = I + IDELT(ICORN+1)
          Y(NPT) = 2 + IDELT(ICORN)
          GO TO (60,70,60,70),ICORN
60        Y(NPT) = Y(NPT) + DELTA*(IDELT(ICORN+1)-IDELT(ICORN))
          GO TO 80
70        X(NPT) = X(NPT) + DELTA*(IDELT(ICORN+2)-IDELT(ICORN+1))
80        IF (NPT-2) 120,90,90
90        CONTINUE
          T1 = 0.0
          T2 = 0.0
          Z1 = 0.0
          Z2 = 0.0
          IF (Y(1) .GE. 1.0 .AND. Y(1) .LE. 2.0) THEN
            T1 = THETA1 + (Y(1) - 1.0)*(THETA2 - THETA1)
          END IF
          IF (Y(2) .GE. 1.0 .AND. Y(2) .LE. 2.0) THEN
            T2 = THETA1 + (Y(2) - 1.0)*(THETA2 - THETA1)
          END IF
          XDELTA = X(1) - FLOAT(I-1)
          IF (Y(1) .LE. 1.0) THEN
             Z1 = ZZ1(I-1) + XDELTA*(ZZ1(I) - ZZ1(I-1))
          ELSE
             Z1 = ZZ2(I-1) + XDELTA*(ZZ2(I) - ZZ2(I-1))
          END IF
          XDELTA = X(2) - FLOAT(I-1)
          IF (Y(2) .LE. 1.0) THEN
             Z2 = ZZ1(I-1) + XDELTA*(ZZ1(I) - ZZ1(I-1))
          ELSE
             Z2 = ZZ2(I-1) + XDELTA*(ZZ2(I) - ZZ2(I-1))
          END IF
          CALL STORELL(T1,Z1,T2,Z2)
          XL = X(2)
          YL = Y(2)
110       NPT = 0
120     CONTINUE
130   CONTINUE
100   CONTINUE
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE STORELL(x1,y1,x2,y2)
      COMMON /NUMBPT/ NP
      COMMON /XARRAY/ ARRAY(4,9000)
      p1 = x1
      p2 = x2
      r1 = y1
      r2 = y2
      d = sqrt((x1-x2)**2 + (y1-y2)**2)
      IF (p1 .GT. 1.01 .OR. p2 .GT. 1.01) RETURN
      IF (r1 .GT. 1.01 .OR. r2 .GT. 1.01) RETURN
      IF (p1 .LT. 0.0 .OR. p2 .LT. 0.0) RETURN
      IF (r1 .LT. 0.0 .OR. r2 .LT. 0.0) RETURN
      if (p1 .ge. 0.0 .and. p1 .le. 1.0) then
        if (p2 .ge. 0.0 .and. p2 .le. 1.0) then
          if (r1 .ge. 0.0 .and. r1 .le. 1.0) then
            if (r2 .ge. 0.0 .and. r2 .le. 1.0) then
              NP = NP + 1
              IF (NP .GT. 9000) RETURN
              ARRAY(1,NP) = p1
              ARRAY(2,NP) = r1
              ARRAY(3,NP) = p2
              ARRAY(4,NP) = r2
            end if
          end if
        end if
      end if
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE DUMPCL(ARRAY,N,ICOL,WIDTH)
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      DIMENSION ARRAY(4,9000)
      CHARACTER*1  BRAK1,BRAK2
      DATA BRAK1,BRAK2 /'[',']'/
      IDSH = 0
      NN   = MIN(N,9000)
      DO 10 K = 1,4,2
        DO 10 I = 1,NN
            ARRAY(K,I)   = ARRAY(K,I)*(XFR2 - XFR1) + XFR1
            ARRAY(K+1,I) = ARRAY(K+1,I)*(YFR2 - YFR1) + YFR1
10    CONTINUE
      DO 6 L = 1,NN,30
        L1 = L
        L2 = L + 29
        IF (L2 .GT. NN) L2 = NN
        LD = L2 - L1
        if (ICOL .ne. 0) WRITE (LF,1) WIDTH,ICOL
        if (ICOL .eq. 0) WRITE (LF,1) WIDTH
1       FORMAT (2X,F8.2,I5)
        NI  = 8
        IF (LD .LT. 8) NI = LD
        DO 5 K = 1,4
          WRITE (LF,2) BRAK1,(ARRAY(K,I),I=L1,L1+NI)
2         FORMAT (2X,A1,9F6.1)
          IF (NN .GT. 9) THEN
            DO 4 J = L1+9,L2,9
              N1   = J
              N2   = J + 8
              IF (N2 .GT. L2) N2 = L2
              WRITE (LF,3) (ARRAY(K,I),I=N1,N2)
3             FORMAT (3X,9F6.1)
4           CONTINUE
          END IF
          WRITE (LF,2) BRAK2
5       CONTINUE
        if (ICOL .ne. 0) WRITE (LF,*) '  xyxyclr '
        if (ICOL .eq. 0) WRITE (LF,*) '  xyxybw '
6     CONTINUE
      RETURN
      END
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine fndslope(y1,slope,nn)
      double precision sx,sy,sx2,syx,a,b,bias
      dimension y1(21)
      sx   = 0.0
      sy   = 0.0
      sx2  = 0.0
      syx  = 0.0
      iprm = 0
      do i = 1,nn
        bias = y1(i)
        sy = sy + bias
        sx = sx + float(i)
        sx2 = sx2 + float(i)**2
        syx = syx + bias*float(i)
        iprm = iprm + 1
      end do
      prom = sy/float(iprm)
      a = (sx*sy - syx*float(iprm))/(sx*sx - float(iprm)*sx2)
      b = (sx*syx - sx2*sy)/(sx*sx - float(iprm)*sx2)
      slope = a
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine fitlin(xx,yy,n,a,b)
      dimension xx(n),yy(n)
      real*8  x(31),y(31)
      real*8  sumx,sumy,sumxx,sumxy,xbar,ybar,a,b
      sumx  = 0.
      do i = 1,n
        y(i) = yy(i)
        sumx  = sumx + x(i)
      end do
      sumx = sumx/float(n)
      do i = 1,n
        x(i) = xx(i) - sumx
      end do
      sumx  = 0.
      sumy  = 0.
      sumxx = 0.
      sumxy = 0.
      do i = 1,n
        sumx  = sumx + x(i)
        sumy  = sumy + y(i)
        sumxx = sumxx + x(i)**2
        sumxy = sumxy + x(i)*y(i)
      end do
      xbar = sumx/float(n)
      ybar = sumy/float(n)
      b = (sumxy - float(n)*xbar*ybar)/(sumxx-float(n)*xbar**2)
      a = ybar - b*xbar
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
