      PROGRAM plot_tia
C--------1---------2---------3---------4---------5---------6---------7-V
C        This programs displays TEC values produced by lisnplt         V
C          the purpose is to demonstrate that Tropical anomaly exists  V
C--------1---------2---------3---------4---------5---------6---------7-V
      character*1 cha1
      character*8 root
      character*16 filename
      character*32 CFILE
      INTEGER   IYD
      REAL SEC,ALT,GGLAT,GGLON,STL,F107A,F107
      REAL W(3),AP(2)
      REAL ue,un,uz,ufa
      dimension kp(366,8),ff107(366),kapp(366,9)
      common /commkp/ kp,nkp,ff107,kapp
      integer   ndayreg(12),ndaybis(12)
      common /cmmprog/ kyear,kmonth,kday,kdoy
      integer jtindx(366),jlindx(100,366)
      common /cmmindx/ jtindx,jlindx
      integer jtime(100,366),jyear(366),jmonth(366),jday(366)
      common /cmmdata/ jtime,jyear,jmonth,jday
      dimension glat(300,100,366),glon(300,100,366),tec(300,100,366)
      common /cmmltln/ glat,glon,tec
      common /cmmflag/ iflag
      common /cmprog1/ kkyear,kkmonth,kkdy
      common /cmfline/ jfline
      common /cjtime2/ jtime2
      dimension windM(7,366)
      common /cmmwind/windM
      dimension xlatwind(7),xlonwind(7)
      common /cmmxltxln/ xlatwind,xlonwind
      common /cmioption/ ioption
      data ndayreg /31,28,31,30,31,30,31,31,30,31,30,31/
      data ndaybis /31,29,31,30,31,30,31,31,30,31,30,31/
      data root /'b-files/'/
      data filename /'byymmdd_0000.dat'/
      kkyear = 2012
      i365   = 365
      jfline = 1
      jtime2 = 17
      ioption = 3
      inarg = iargc()
      if (inarg .ge. 1) then
        CALL GETARG(1,CFILE)
        read (CFILE,*,end=1,err=1) jfline
        if (inarg .eq. 2) then
          CALL GETARG(2,CFILE)
          read (CFILE,*,end=1,err=1) jtime2
          print *,'FieldLine, LT: ',jfline,jtime2
        end if
      end if
      print *,jfline,jtime2
      if (mod(kkyear,4) .eq. 0) i365 = 366
      open (7,file='tape7',status='UNKNOWN')
      open (8,file='tape8',status='UNKNOWN')
      open (9,file='tape9',status='UNKNOWN')
      open (10,file='tape10',status='UNKNOWN')
      NPAGES = 0
      do i = 1,i365
        call fndymd(kkyear,kkmonth,kkdy,i)
        write (filename(2:7),fmt='(3i2.2)') mod(kkyear,100),kkmonth,kkdy
        print *,root//filename
        open (84,file=root//filename,status='UNKNOWN')
        call read9time(i)
2       continue
      end do
      write (7,fmt='(12i5)') (jyear(i),i=1,i365)
      write (7,fmt='(12i5)') (jmonth(i),i=1,i365)
      write (7,fmt='(12i5)') (jday(i),i=1,i365)
      do i = 1,48
c        write (7,fmt='(15i4)') (jlindx(i,j),j=1,i365)
      end do
      do i = 1,i365
c        write (7,fmt='(10i6)') (jtime(j,i),j=1,48)
      end do
      do i = 1,i365
        write (8,fmt='(a6,3i5)') 'Y,M,D ',jyear(i),jmonth(i),jday(i)
        do j = 1,48
          indxlat = jlindx(j,i)
          i42 = indxlat
          write (8,fmt='(a5,i6)') 'time: ',jtime(j,i)
c          write (8,fmt='(10f10.2)') (glat(k,j,i),k=1,i42)
c          write (8,fmt='(10f10.2)') (glon(k,j,i),k=1,i42)
c          write (8,fmt='(10f10.2)') (tec(k,j,i),k=1,i42)
        end do
      end do
      call plotTEC
      call readkp(kkyear)
      indxtim = jtime2*2 + 1
      if (indxtim .gt. 48) indxtim = 48
      if (jfline .eq. 1) jjindx = 121
      if (jfline .eq. 2) jjindx = 1
      do ij = 1,7
        xumin = 999.0
        xumax = -999.0
        jjindx = 121 - (ij-1)*20
        GGLAT = glat(jjindx,indxtim,1)
        GGLON = glon(jjindx,indxtim,1)
        xlatwind(ij) = GGLAT
        xlonwind(ij) = GGLON
        write (9,*) 'latitude: ',ij,GGLAT
        do i = 1,i365
          kdoy = i
          IYD = mod(kkyear,100)*1000 + i
          SEC = float(jtime2)*3600.0
          ALT = 300.0
          GGLAT = glat(jjindx,indxtim,i)
          GGLON = glon(jjindx,indxtim,i)
C          STL  = SEC/3600.0 + GGLON/15.0
          STL  = SEC/3600.0
          F107 = ff107(i)
          F107A = ff107(i)
          AP(1) = kapp(i,9)
          iixx  = 1 + (jtime2-1)/3
          AP(2) = kapp(i,iixx)
          call llwind(IYD,SEC,ALT,GGLAT,GGLON,STL,F107A,F107,AP,W,ufa)
          write (9,fmt='(i6,8f10.2)') IYD,SEC,GGLAT,GGLON,STL,F107A,F107
     &      ,W(1),W(2)
          if (ioption .eq. 1) then
            windM(ij,i) = W(1)
          else if (ioption .eq. 2) then
            windM(ij,i) = W(2)
          else if (ioption .eq. 3) then
            windM(ij,i) = ufa
          end if
          if (windM(ij,i) .lt. xumin) xumin = windM(ij,i)
          if (windM(ij,i) .gt. xumax) xumax = windM(ij,i)
        end do
        write (10,fmt='(2f10.3)') GGLAT,GGLON
        write (10,fmt='(11f8.2)') (windM(ij,i),i=1,i365)
        print *,'Max,Min ',GGLAT,GGLON,xumax,xumin
      end do
      call plotWIND
1     continue
      stop
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine read9time(idoy)
      character*4 chayear
      character*99 cha99
      common /cmmprog/ kyear,kmonth,kday,kdoy
      integer jtindx(366),jlindx(100,366)
      common /cmmindx/ jtindx,jlindx
      integer jtime(100,366),jyear(366),jmonth(366),jday(366)
      common /cmmdata/ jtime,jyear,jmonth,jday
      dimension glat(300,100,366),glon(300,100,366),tec(300,100,366)
      common /cmmltln/ glat,glon,tec
      common /cmmflag/ iflag
      dimension xyzlon(10),xyzlat(10)
      common /cmmxyzl/ xyzlon,xyzlat
      common /cmprog1/ kkyear,kkmonth,kkdy
      dimension clat(3,121),clon(3,121),ctec(3,121)
      common /clatclon/ clat,clon,ctec
      common /cmfline/  jfline
      nlongsc = 3
      jtindx(idoy) = 0
      write (chayear,fmt='(i4)') kkyear
c      print *,'start of read9time'
10    continue
      read (84,fmt='(7i4)',end=2,err=2)kyear,kmonth,kday,khour,kmin,ksec
C      print *,kyear,kmonth,kday,khour,kmin,idoy
      jyear(idoy)  = kyear
      jmonth(idoy) = kmonth
      jday(idoy)   = kday
      read (84,fmt='(6f10.2)') (xyzlon(i),xyzlat(i),i=1,nlongsc)
      xequlat = xyzlat(3)
      do i = 1,121
        read (84,fmt='(9f11.4)') clat(1,i),clon(1,i),ctec(1,i),clat(2,i)
     &    ,clon(2,i),ctec(2,i),clat(3,i),clon(3,i),ctec(3,i)
      end do
      avegtec = 0.0
      iavegtec = 0
      do i = 1,121
        if (clat(3,i).gt.xequlat-12. .and. clat(3,i).lt.xequlat+12.) 
     &    then
          avegtec = avegtec + ctec(3,i)
          iavegtec = iavegtec + 1
        end if
      end do
      avegtec = avegtec/float(iavegtec)
      if (khour .eq. 0 .and. kmin .eq. 0) then
C        print *,kyear,kmonth,kday,xequlat,iavegtec,avegtec
      end if
C      print *,khour,kmin,ksec
      itime = khour*3600 + kmin*60 + ksec
      jtindx(idoy) = jtindx(idoy) + 1
      indxtim = jtindx(idoy)
      jtime(indxtim,idoy) = itime
      jlindx(indxtim,idoy) = 0
      do i = 1,121
        jlindx(indxtim,idoy) = jlindx(indxtim,idoy) + 1
        indxlat = jlindx(indxtim,idoy)
        glat(indxlat,indxtim,idoy) = clat(jfline,i)
        glon(indxlat,indxtim,idoy) = clon(jfline,i)
C        tec(indxlat,indxtim,idoy)  = (ctec(jfline,i) - avegtec)*10.0
        tec(indxlat,indxtim,idoy)  = ctec(jfline,i)/avegtec
      end do
      go to 10
2     continue
      iflag = 1
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine plotTEC
      character*5 cha5
      character*4 cha4
      character*3 chaday(12),cha3
      character*2 cha2
      integer inday(12)
      common /cmmprog/ kyear,kmonth,kday,kdoy
      integer jtindx(366),jlindx(100,366)
      common /cmmindx/ jtindx,jlindx
      integer jtime(100,366),jyear(366),jmonth(366),jday(366)
      common /cmmdata/ jtime,jyear,jmonth,jday
      dimension glat(300,100,366),glon(300,100,366),tec(300,100,366)
      common /cmmltln/ glat,glon,tec
      dimension xyzlon(10),xyzlat(10)
      common /cmmxyzl/ xyzlon,xyzlat
      common /cmfline/ jfline
      common /cjtime2/ jtime2
      data chaday /'jan','feb','mar','apr','may','jun','jul','aug','sep'
     &  ,'oct','nov','dec'/
      data inday /31,28,31,30,31,30,31,31,30,31,30,31/
      n366 = 365
      inday(2) = 28
      if (mod(kyear,4) .eq. 0) n366 = 366
      if (mod(kyear,4) .eq. 0) inday(2) = inday(2) + 1
      print *,'making PLOTTEC'
      iuttime = jtime2*3600
      ihour = iuttime/3600
      iminu = (iuttime - ihour*3600)/60
      write (cha5,fmt='(i2.2,1x,i2.2)') ihour,iminu
      cha5(3:3) = ':'
      call initialize
      call gsave
      NT1 = 7
      NT2 = 11
      ILBL  = 30
      IDLBL = -10
      JLBL  = 1
      JDLBL = 2
      call PLT1x1d(NT1,NT2,NT1,NT2,ILBL,IDLBL,JLBL,JDLBL)
      write (cha4,fmt='(i4)') kyear
      write (cha2,fmt='(i2)') ifix(abs(xyzlon(jfline)))
      call WRTSYMB(-0.03,0.01,20,cha4,90,1,1)
      call WRTSYMB(1.10,0.40,18,' Month of Year',90,1,1)
      call WRTSYMB(-0.03,0.74,18,'Longitude = '//cha2//' West',90,1,1)
      call WRTSYMB(-0.03,0.43,18,'LT = '//cha5,90,1,1)
      call WRTSYMB(0.68,-0.07,18,'Geographic latitude',180,1,1)
      do k = 1,12
        ndays = 0
        do j = 1,k
          ndays = ndays + inday(j)
        end do
        x1 = float(ndays)/float(n366)
        call trline(-0.02,x1,0.02,x1,0,0.8)
        call trline(1.02,x1,0.98,x1,0,0.8)
        x1 = x1 - 2.0/36.0
        call WRTSYMB(1.04,x1,18,chaday(k),90,1,1)
      end do
      i42 = 42
      do i = 1,n366
        y1 = float(i)/float(n366)
        do j = 1,48
          indxlat = jlindx(j,i)
          i42 = indxlat
          if (jtime(j,i) .eq. iuttime) then
            do k = 1,i42
              xlat = glat(k,j,i)
              x1 = 1.0 - (xlat + 50.0)/80.0
c              xtec = tec(k,j,i)/75.0*30.0
c              if (xtec .gt. 30.0) xtec = 30.0
c              if (xtec .lt. 0.0) xtec = 0.0
c              if (xtec .le. 15.0) icol  = ifix(xtec*60.0/15.0)
c              if (xtec .gt. 15.0) icol  = 70 + ifix(2.0*(xtec-15.0))
C   ***   ...   New algorithm to display fractional TEC    ...   ***   V
              xtec = tec(k,j,i)
              if (xtec .ge. 1.0) then
                icol = 70 + ifix((xtec - 1.0)/0.30*29.0)
              else if (xtec .lt. 1.0) then
                icol = 20 - ifix((1.0 - xtec)/0.30*20.0)
              end if
              if (icol .lt. 1) icol = 1
              if (icol .gt. 99) icol = 99
              call PUTCCCDOT(x1,y1,icol)
            end do
          end if
        end do
      end do
      x1 = 1.0 - (xyzlat(jfline) + 50.0)/80.0
      call TWLINE(x1,1.0,x1,0.0,0,1.5)
      if (jfline .eq. 1) then
        call putacol2(0.032,0.5,30.0,0.0,99)
      else if (jfline .eq. 2) then
        call putacol2(0.965,0.08,30.0,180.0,99)
        call putacol2(0.965,0.89,30.0,180.0,99)
      end if
      call yearscale
      call plotend
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      SUBROUTINE PLT1x1d(NT1,NT2,NT3,NT4,ILBL,IDLBL,JLBL,JDLBL)
      COMMON /CM0001/ NPAGES,NPLOTS,NPLOTP
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      COMMON /CM0007/ TIN1PER,OUT1PER,TIN2PER,OUT2PER,TIN3PER,OUT3PER,
     1  TIN4PER,OUT4PER
      DATA XLENG,YLENG /612.,792./
      NPLOTS = NPLOTS + 1
      OUT1PER = 1.3
      TIN1PER = 1.3
      OUT3PER = 1.3
      TIN3PER = 1.3
      TIN2PER = 0.25
      OUT2PER = 0.25
      TIN4PER = 0.25
      OUT4PER = 0.25
      XFR1    = 80.0
      XFR2    = XFR1 + 420.0
      YFR1    = 80.0
      YFR2    = YFR1 + 610.0
C        DRAW THE BOX
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      CALL TICK6(NT1,1)
      CALL TICK6(NT3,3)
c      CALL TICK6(NT2,2)
c      CALL TICK6(NT4,4)
      DX1 = (XFR2 - XFR1)/FLOAT(NT1+1)
      DY1 = (YFR2 - YFR1)/FLOAT(NT2+1)
      if (IDLBL .ne. -1) then
        CALL PUTLBL(XFR1+5.0,YFR1-30.0,DX1,NT1+2,1,ILBL,IDLBL,1,90,14)
      else
        CALL PUTLBL(XFR1+5.0,YFR1-30.0,DX1,13,1,ILBL,IDLBL,1,90,15)
        CALL PUTLBL(XFR1+5.0+13.0*DX1,YFR1-30.0,DX1,NT1+2-13,1,23,IDLBL,
     &    1,90,15)
      end if
      y13 = 0.5
      call trline(0.0,0.0,-0.03,0.0,0,0.5)
      call trline(0.0,1.0,-0.03,1.0,0,0.5)
      call trline(1.0,0.0,1.03,0.0,0,0.5)
      call trline(1.0,1.0,1.03,1.0,0,0.5)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine yearscale
      common /cmmprog/ kyear,kmonth,kday,kdoy
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      dimension xx(400),yy(400)
      character*4 cha4
      XFR1  = 70.0
      XFR2  = XFR1 + 460.0
      YFR1  = 70.0
      YFR2  = YFR1 + 645.0
      nn   = 5
      yy(1) = 0.99
      yy(2) = 0.99
      yy(3) = 1.03
      yy(4) = 1.03
      yy(5) = 0.99
      do i = 1,30
        xx(1) = 0.75 - float(i-1)*0.02
        xx(2) = 0.77 - float(i-1)*0.02
        xx(3) = 0.77 - float(i-1)*0.02
        xx(4) = 0.75 - float(i-1)*0.02
        xx(5) = 0.75 - float(i-1)*0.02
        if (i .le. 15) icol  = ifix(float(i)*20.0/15.0)
        if (i .gt. 15) icol  = 71 + 2*(i-16)
        call makpant(xx,yy,nn,icol)
      end do
      do i = 1,5
        x1 = 0.77 - float(i-1)*0.15
        call trline(x1,0.99,x1,1.04,0,0.8)
        write (cha4,fmt='(f4.2)') 0.70+0.15*float(i-1)
        call WRTSYMB(x1+0.01,1.045,16,cha4,90,1,1)
      end do
      call WRTSYMB(0.11,0.975,20,'TEC rate',90,1,1)
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine makpant(x,y,n,icol)
      DIMENSION x(400),y(400)
      DIMENSION     array(2,4000)
      CHARACTER*1  BRAK1,BRAK2
      COMMON /CMLF/   LF
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      DATA BRAK1,BRAK2 /'[',']'/
      if (n .eq. 0) return
      DO 1 i = 1,n
        array(1,i) = x(i)
        array(2,i) = y(i)
1     CONTINUE
      DO 10 i = 1,n
        array(1,i) = array(1,i)*(XFR2 - XFR1) + XFR1
        array(2,i) = array(2,i)*(YFR2 - YFR1) + YFR1
10    CONTINUE
      NI = 12
      IF (n .LT. 12) NI = n
      WRITE (LF,2) BRAK1,(array(1,I),I=1,NI)
2     FORMAT (2X,A1,12F6.1)
      IF (n .GT. 12) THEN
        DO 4 J = 13,n,12
          N1   = J
          N2   = J + 11
          IF (N2 .GT. n) N2 = n
          WRITE (LF,3) (array(1,I),I=N1,N2)
3         FORMAT (3X,12F6.1)
4       CONTINUE
      END IF
      WRITE (LF,2) BRAK2
      WRITE (LF,2) BRAK1,(array(2,I),I=1,NI)
      IF (n .GT. 12) THEN
        DO 5 J = 13,n,12
          N1   = J
          N2   = J + 11
          IF (N2 .GT. n) N2 = n
          WRITE (LF,3) (array(2,I),I=N1,N2)
5       CONTINUE
      END IF
      WRITE (LF,2) BRAK2
      if (icol .gt. 0) WRITE (LF,6) icol
6     FORMAT (2x,i4,2x,'cpaint')
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine fndymd(iyear,month,iday,idoy)
      DIMENSION MO(12),MObis(12)
      DATA  MO/0,31,59,90,120,151,181,212,243,273,304,334/
      DATA  MObis/0,31,60,91,121,152,182,213,244,274,305,335/
      i4     = mod(iyear,4)
      IMO    = 0
      MOBE   = 0
5     IMO    = IMO + 1
      MOOLD  = MOBE
      IF (IMO .GT. 12) GO TO 55
      if (i4 .ne. 0) MOBE   = MO(IMO)
      if (i4 .eq. 0) MOBE   = MObis(IMO)
      IF(MOBE .LT. idoy) GO TO 5
55    MONTH  = IMO - 1
      iday   = idoy - MOOLD
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine readkp(iyear)
      character*3 chaissn
      character*7 filename
      integer kkp(8),kap(9)
      dimension kp(366,8),ff107(366),kapp(366,9)
      common /commkp/ kp,nkp,ff107,kapp
      data filename /'1994.kp'/
      write (filename(1:4),fmt='(i4.4)') iyear
      open (12,file=filename,status='OLD')
      ii = 0
1     continue
      if (iyear .le. 2015) then
       read (12,2,err=100,end=100) iy,im,id,ibartel,nbart,(kkp(i),i=1,8)
     1  ,kps,(kap(i),i=1,9),cp,ic9,issn,f107
2     format (3i2,i4,i2,8i2,10i3,f3.1,i1,i3,f5.1)
      else if (iyear .gt. 2015) then
       read (12,3,err=100,end=100) iy,im,id,ibartel,nbart,(kkp(i),i=1,8)
     1  ,kps,(kap(i),i=1,8),f107
3     format (3i2,i4,i2,8i2,9i3,f7.1)
      end if
      ii = ii + 1
      do i = 1,8
        kp(ii,i) = kkp(i)
      end do
      do i = 1,9
        kapp(ii,i) = kap(i)
      end do
      ff107(ii) = f107
      go to 1
100   continue
c      print *,ii
      nkp = ii
      close (12)
      print *,'readkp: ',filename,nkp
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
      subroutine plotWIND
      character*5 cha5
      character*4 cha4
      character*3 chaday(12),cha3
      character*2 cha2
      character*1 cha1
      integer inday(12)
      COMMON /CM0006/ XFR1,YFR1,XFR2,YFR2
      dimension windM(7,366)
      common /cmmwind/windM
      common /cmprog1/ kkyear,kkmonth,kkdy
      common /cmmprog/ kyear,kmonth,kday,kdoy
      dimension xyzlon(10),xyzlat(10)
      common /cmmxyzl/ xyzlon,xyzlat
      common /cmfline/ jfline
      common /cjtime2/ jtime2
      dimension xlatwind(7),xlonwind(7)
      common /cmmxltxln/ xlatwind,xlonwind
      common /cmioption/ ioption
      data chaday /'jan','feb','mar','apr','may','jun','jul','aug','sep'
     &  ,'oct','nov','dec'/
      data inday /31,28,31,30,31,30,31,31,30,31,30,31/
      n366 = 365
      inday(2) = 28
      if (mod(kyear,4) .eq. 0) n366 = 366
      if (mod(kyear,4) .eq. 0) inday(2) = inday(2) + 1
      iuttime = jtime2*3600
      ihour = iuttime/3600
      iminu = (iuttime - ihour*3600)/60
      write (cha5,fmt='(i2.2,1x,i2.2)') ihour,iminu
      cha5(3:3) = ':'
      print *,'making plotWIND'
      call initialize
      call gsave
      XFR1  = 80.0
      XFR2  = XFR1 + 440.0
      YFR1  = 80.0
      YFR2  = YFR1 + 500.0
      write (cha4,fmt='(i4)') kkyear
      write (cha2,fmt='(i2)') ifix(abs(xyzlon(jfline)))
      write (cha1,fmt='(i1)') ioption
C        DRAW THE BOX
      CALL BOX(XFR1,YFR1,XFR2,YFR2)
      do i = 1,7
        y1 = float(i)/8.0
        call trline(0.0,y1,1.0,y1,0,0.75)
      end do
      call WRTSYMB(0.01,1.015,20,cha4,0,1,1)
      call WRTSYMB(0.20,1.015,20,cha1,0,1,1)
      call WRTSYMB(0.5,-0.075,18,'Month of Year',0,2,1)
      call WRTSYMB(1.0,1.015,18,'Longitude = '//cha2//' West',0,3,1)
      call WRTSYMB(0.30,1.015,18,'LT = '//cha5,0,1,1)
      call WRTSYMB(-0.11,0.33,20,'Geographic Latitude',90,1,1)
      call WRTSYMB(1.13,0.68,20,'Geographic Longitude',-90,1,1)
      call WRTSYMB(1.13,1.0,20,'WIND',-90,1,1)
      call WRTSYMB(1.13,0.11,20,'WIND',-90,1,1)
      if (ioption .eq. 1) then
        call WRTSYMB(0.01,1.07,20,'North-South WIND',0,1,1)
      else if (ioption .eq. 2) then
        call WRTSYMB(0.01,1.07,20,'Zonal WIND',0,1,1)
      else if (ioption .eq. 3) then
        call WRTSYMB(0.01,1.07,20,'WIND along B Line',0,1,1)
      end if
      if (jfline .eq. 1) call WRTSYMB(-0.06,1.015,20,'(a)',0,3,1)
      if (jfline .eq. 2) call WRTSYMB(-0.06,1.015,20,'(b)',0,3,1)
      do k = 1,12
        ndays = 0
        do j = 1,k
          ndays = ndays + inday(j)
        end do
        x1 = float(ndays)/float(n366)
        call trline(x1,-0.01,x1,0.01,0,0.8)
        call trline(x1,0.99,x1,1.01,0,0.8)
        x1 = x1 - 1.0/24.0
        call WRTSYMB(x1,-0.03,18,chaday(k),0,2,1)
      end do
      do i = 1,2
        y1 = 1.0 - float(i-1)/16.0
        call trline(-0.01,y1,0.01,y1,0,0.8)
        call trline(0.99,y1,1.01,y1,0,0.8)
        if (i .eq. 1) call WRTSYMB(1.01,y1-0.01,16,'100',0,1,1)
        if (i .eq. 2) call WRTSYMB(1.01,y1-0.01,16,'50',0,1,1)
        y1 = float(i-1)/16.0
        call trline(-0.01,y1,0.01,y1,0,0.8)
        call trline(0.99,y1,1.01,y1,0,0.8)
        if (i .eq. 1) call WRTSYMB(1.01,y1-0.01,16,'-100',0,1,1)
        if (i .eq. 2) call WRTSYMB(1.01,y1-0.01,16,'-50',0,1,1)
      end do
      do i = 1,7
        y1 = 1.0 - float(i)/8.0
        GGLAT = xlatwind(i)
        GGLON = xlonwind(i)
        write (cha5,fmt='(f5.1)') GGLAT
        call WRTSYMB(-0.015,y1-0.015,18,cha5,0,3,1)
        write (cha5,fmt='(f5.1)') GGLON
        call WRTSYMB(1.015,y1-0.015,18,cha5,0,1,1)
        do j = 1,n366
          x1 = float(j)/float(n366)
          y1 = 1.0 - float(i)/8.0 + windM(i,j)/100.0/8.0
          if (windM(i,j) .ge. 0.0) icol = 10
          if (windM(i,j) .lt. 0.0) icol = 99
          if (y1 .gt. -0.05) then
            call PUTCCCDOT(x1,y1,icol)
          end if
        end do
      end do
      call plotend
      return
      end
C--------1---------2---------3---------4---------5---------6---------7-V
